// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_photo_capabilities.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_settings_range.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"fillLightMode",
"imageHeight",
"imageWidth",
"redEyeReduction",
};


}  // namespace 

PhotoCapabilities* PhotoCapabilities::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PhotoCapabilities* dictionary = MakeGarbageCollected<PhotoCapabilities>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PhotoCapabilities";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PhotoCapabilities::PhotoCapabilities() {
  
}

 PhotoCapabilities::PhotoCapabilities(v8::Isolate* isolate) {
  
}



Vector<V8FillLightMode> PhotoCapabilities::getFillLightModeOr(const Vector<V8FillLightMode>& fallback_value) const {
  if (!hasFillLightMode()) {
  return fallback_value;
}
return member_fill_light_mode_;
}

Vector<V8FillLightMode> PhotoCapabilities::getFillLightModeOr(Vector<V8FillLightMode>&& fallback_value) const {
  if (!hasFillLightMode()) {
  return std::move(fallback_value);
}
return member_fill_light_mode_;
}

void PhotoCapabilities::setFillLightMode(const Vector<V8FillLightMode>& value) {
  member_fill_light_mode_ = value;
has_fill_light_mode_ = true;
}

void PhotoCapabilities::setFillLightMode(Vector<V8FillLightMode>&& value) {
  member_fill_light_mode_ = std::move(value);
has_fill_light_mode_ = true;
}
























void PhotoCapabilities::Trace(Visitor* visitor) const {
  visitor->Trace(member_image_height_);
visitor->Trace(member_image_width_);
bindings::DictionaryBase::Trace(visitor);
}

void PhotoCapabilities::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PhotoCapabilities::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasFillLightMode()) {
  values[0] = ToV8Traits<IDLSequence<V8FillLightMode>>::ToV8(script_state, member_fill_light_mode_);
DCHECK(!values[0].IsEmpty());
}
if (hasImageHeight()) {
  values[1] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_image_height_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasImageWidth()) {
  values[2] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_image_width_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasRedEyeReduction()) {
  values[3] = ToV8Traits<V8RedEyeReduction>::ToV8(script_state, member_red_eye_reduction_);
DCHECK(!values[3].IsEmpty());
}
}

const void* PhotoCapabilities::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PhotoCapabilities::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PhotoCapabilities::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PhotoCapabilities";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("fillLightMode");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8FillLightMode>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_fill_light_mode_, member_fill_light_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("imageHeight");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_image_height_, member_image_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("imageWidth");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_image_width_, member_image_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("redEyeReduction");
if (!bindings::GetDictionaryMemberFromV8Object<V8RedEyeReduction, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_red_eye_reduction_, member_red_eye_reduction_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PhotoCapabilities::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
