// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_permission_name.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"

namespace blink {



constexpr const char* const V8PermissionName::string_table_[] = {
"geolocation", "notifications", "push", "midi", "camera", "microphone", "background-fetch", "background-sync", "persistent-storage", "ambient-light-sensor", "accelerometer", "gyroscope", "magnetometer", "screen-wake-lock", "nfc", "display-capture", "clipboard-read", "clipboard-write", "payment-handler", "idle-detection", "periodic-background-sync", "system-wake-lock", "storage-access", "window-management", "local-fonts", "top-level-storage-access", "captured-surface-control", "speaker-selection", "keyboard-lock", "pointer-lock", "fullscreen", "web-app-installation", "local-network-access"
};

V8PermissionName V8PermissionName::Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state) {
  const auto& result = bindings::FindIndexInEnumStringTable(isolate, value, string_table_, "PermissionName", exception_state);
return result.has_value() ? V8PermissionName(static_cast<Enum>(result.value())) : V8PermissionName();
}

std::optional<V8PermissionName> V8PermissionName::Create(const String& value) {
  const auto& result = bindings::FindIndexInEnumStringTable(value, string_table_);
if (!result)
  return std::nullopt;
return V8PermissionName(static_cast<Enum>(result.value()));
}


static_assert(std::is_trivially_copyable<V8PermissionName>::value, "");






}  // namespace blink
