// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_REQUEST_DETAILS_UPDATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_REQUEST_DETAILS_UPDATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AddressErrors;
class ExceptionState;
class PaymentCurrencyAmount;
class PaymentDetailsModifier;
class PaymentShippingOption;

class MODULES_EXPORT PaymentRequestDetailsUpdate : public bindings::DictionaryBase {
  
  public:
static PaymentRequestDetailsUpdate* Create() {
  return MakeGarbageCollected<PaymentRequestDetailsUpdate>();
}
static PaymentRequestDetailsUpdate* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentRequestDetailsUpdate>(isolate);
}
static PaymentRequestDetailsUpdate* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentRequestDetailsUpdate();
explicit  PaymentRequestDetailsUpdate(v8::Isolate* isolate);

bool hasError() const {
  return has_error_;
}
const String& error() const {
  DCHECK(hasError());
return member_error_;
}
String getErrorOr(const String& fallback_value) const;
String getErrorOr(String&& fallback_value) const;
void setError(const String& value);
void setError(String&& value);

bool hasModifiers() const {
  return has_modifiers_;
}
const HeapVector<Member<PaymentDetailsModifier>>& modifiers() const {
  DCHECK(hasModifiers());
return member_modifiers_;
}
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const;
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const;
void setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value);
void setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value);

bool hasPaymentMethodErrors() const {
  return has_payment_method_errors_;
}
const ScriptObject& paymentMethodErrors() const {
  DCHECK(hasPaymentMethodErrors());
return member_payment_method_errors_;
}
ScriptObject getPaymentMethodErrorsOr(const ScriptObject& fallback_value) const {
  if (!hasPaymentMethodErrors()) {
  return fallback_value;
}
return member_payment_method_errors_;
}
void setPaymentMethodErrors(const ScriptObject& value) {
  member_payment_method_errors_ = value;
has_payment_method_errors_ = true;
}

bool hasShippingAddressErrors() const {
  return has_shipping_address_errors_;
}
AddressErrors* shippingAddressErrors() const {
  DCHECK(hasShippingAddressErrors());
return member_shipping_address_errors_.Get();
}
AddressErrors* getShippingAddressErrorsOr(AddressErrors* fallback_value) const {
  if (!hasShippingAddressErrors()) {
  return fallback_value;
}
return member_shipping_address_errors_.Get();
}
void setShippingAddressErrors(AddressErrors* value) {
  member_shipping_address_errors_ = value;
has_shipping_address_errors_ = true;
DCHECK(member_shipping_address_errors_);
}

bool hasShippingOptions() const {
  return has_shipping_options_;
}
const HeapVector<Member<PaymentShippingOption>>& shippingOptions() const {
  DCHECK(hasShippingOptions());
return member_shipping_options_;
}
HeapVector<Member<PaymentShippingOption>> getShippingOptionsOr(const HeapVector<Member<PaymentShippingOption>>& fallback_value) const;
HeapVector<Member<PaymentShippingOption>> getShippingOptionsOr(HeapVector<Member<PaymentShippingOption>>&& fallback_value) const;
void setShippingOptions(const HeapVector<Member<PaymentShippingOption>>& value);
void setShippingOptions(HeapVector<Member<PaymentShippingOption>>&& value);

bool hasTotal() const {
  return has_total_;
}
PaymentCurrencyAmount* total() const {
  DCHECK(hasTotal());
return member_total_.Get();
}
PaymentCurrencyAmount* getTotalOr(PaymentCurrencyAmount* fallback_value) const {
  if (!hasTotal()) {
  return fallback_value;
}
return member_total_.Get();
}
void setTotal(PaymentCurrencyAmount* value) {
  member_total_ = value;
has_total_ = true;
DCHECK(member_total_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_error_ = false;
bool has_modifiers_ = false;
bool has_payment_method_errors_ = false;
bool has_shipping_address_errors_ = false;
bool has_shipping_options_ = false;
bool has_total_ = false;

String member_error_;
HeapVector<Member<PaymentDetailsModifier>> member_modifiers_;
ScriptObject member_payment_method_errors_;
Member<AddressErrors> member_shipping_address_errors_;
HeapVector<Member<PaymentShippingOption>> member_shipping_options_;
Member<PaymentCurrencyAmount> member_total_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_REQUEST_DETAILS_UPDATE_H_
