// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_OPUS_ENCODER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_OPUS_ENCODER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_opus_application.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_opus_bitstream_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_opus_signal.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT OpusEncoderConfig : public bindings::DictionaryBase {
  
  public:
static OpusEncoderConfig* Create() {
  return MakeGarbageCollected<OpusEncoderConfig>();
}
static OpusEncoderConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<OpusEncoderConfig>(isolate);
}
static OpusEncoderConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  OpusEncoderConfig();
explicit  OpusEncoderConfig(v8::Isolate* isolate);

bool hasApplication() const {
  return true;
}
V8OpusApplication application() const {
  return member_application_;
}
void setApplication(V8OpusApplication value) {
  member_application_ = value;
}
void setApplication(V8OpusApplication::Enum value) {
  member_application_ = V8OpusApplication(value);
}

bool hasComplexity() const {
  return has_complexity_;
}
uint32_t complexity() const {
  DCHECK(hasComplexity());
return member_complexity_;
}
uint32_t getComplexityOr(uint32_t fallback_value) const {
  if (!hasComplexity()) {
  return fallback_value;
}
return member_complexity_;
}
void setComplexity(uint32_t value) {
  member_complexity_ = value;
has_complexity_ = true;
}

bool hasFormat() const {
  return true;
}
V8OpusBitstreamFormat format() const {
  return member_format_;
}
void setFormat(V8OpusBitstreamFormat value) {
  member_format_ = value;
}
void setFormat(V8OpusBitstreamFormat::Enum value) {
  member_format_ = V8OpusBitstreamFormat(value);
}

bool hasFrameDuration() const {
  return true;
}
uint64_t frameDuration() const {
  return member_frame_duration_;
}
void setFrameDuration(uint64_t value) {
  member_frame_duration_ = value;
}

bool hasPacketlossperc() const {
  return true;
}
uint32_t packetlossperc() const {
  return member_packetlossperc_;
}
void setPacketlossperc(uint32_t value) {
  member_packetlossperc_ = value;
}

bool hasSignal() const {
  return true;
}
V8OpusSignal signal() const {
  return member_signal_;
}
void setSignal(V8OpusSignal value) {
  member_signal_ = value;
}
void setSignal(V8OpusSignal::Enum value) {
  member_signal_ = V8OpusSignal(value);
}

bool hasUsedtx() const {
  return true;
}
bool usedtx() const {
  return member_usedtx_;
}
void setUsedtx(bool value) {
  member_usedtx_ = value;
}

bool hasUseinbandfec() const {
  return true;
}
bool useinbandfec() const {
  return member_useinbandfec_;
}
void setUseinbandfec(bool value) {
  member_useinbandfec_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_complexity_ = false;

V8OpusApplication member_application_{V8OpusApplication::Enum::kAudio};
uint32_t member_complexity_;
V8OpusBitstreamFormat member_format_{V8OpusBitstreamFormat::Enum::kOpus};
uint64_t member_frame_duration_{20000};
uint32_t member_packetlossperc_{0};
V8OpusSignal member_signal_{V8OpusSignal::Enum::kAuto};
bool member_usedtx_{false};
bool member_useinbandfec_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_OPUS_ENCODER_CONFIG_H_
