// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_opus_encoder_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"application",
"complexity",
"format",
"frameDuration",
"packetlossperc",
"signal",
"usedtx",
"useinbandfec",
};


}  // namespace 

OpusEncoderConfig* OpusEncoderConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  OpusEncoderConfig* dictionary = MakeGarbageCollected<OpusEncoderConfig>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "OpusEncoderConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 OpusEncoderConfig::OpusEncoderConfig() {
  
}

 OpusEncoderConfig::OpusEncoderConfig(v8::Isolate* isolate) {
  
}












































void OpusEncoderConfig::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void OpusEncoderConfig::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void OpusEncoderConfig::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasApplication()) {
  values[0] = ToV8Traits<V8OpusApplication>::ToV8(script_state, member_application_);
DCHECK(!values[0].IsEmpty());
}
if (hasComplexity()) {
  values[1] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_complexity_);
DCHECK(!values[1].IsEmpty());
}
if (hasFormat()) {
  values[2] = ToV8Traits<V8OpusBitstreamFormat>::ToV8(script_state, member_format_);
DCHECK(!values[2].IsEmpty());
}
if (hasFrameDuration()) {
  values[3] = ToV8Traits<IDLUnsignedLongLongEnforceRange>::ToV8(script_state, member_frame_duration_);
DCHECK(!values[3].IsEmpty());
}
if (hasPacketlossperc()) {
  values[4] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_packetlossperc_);
DCHECK(!values[4].IsEmpty());
}
if (hasSignal()) {
  values[5] = ToV8Traits<V8OpusSignal>::ToV8(script_state, member_signal_);
DCHECK(!values[5].IsEmpty());
}
if (hasUsedtx()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_usedtx_);
DCHECK(!values[6].IsEmpty());
}
if (hasUseinbandfec()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_useinbandfec_);
DCHECK(!values[7].IsEmpty());
}
}

const void* OpusEncoderConfig::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> OpusEncoderConfig::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void OpusEncoderConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "OpusEncoderConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("application");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8OpusApplication, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_application_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("complexity");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_complexity_, member_complexity_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("format");
if (!bindings::GetDictionaryMemberFromV8Object<V8OpusBitstreamFormat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_format_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_frame_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetlossperc");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_packetlossperc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<V8OpusSignal, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_signal_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usedtx");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_usedtx_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("useinbandfec");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_useinbandfec_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> OpusEncoderConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
