// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NDEF_RECORD_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NDEF_RECORD_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT NDEFRecordInit : public bindings::InputDictionaryBase {
  
  public:
static NDEFRecordInit* Create() {
  return MakeGarbageCollected<NDEFRecordInit>();
}
static NDEFRecordInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NDEFRecordInit>(isolate);
}
static NDEFRecordInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NDEFRecordInit();
explicit  NDEFRecordInit(v8::Isolate* isolate);

bool hasData() const {
  return !member_data_.IsEmpty();
}
const ScriptValue& data() const {
  DCHECK(hasData());
return member_data_;
}
ScriptValue getDataOr(const ScriptValue& fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_;
}
void setData(const ScriptValue& value) {
  member_data_ = value;
}

bool hasEncoding() const {
  return has_encoding_;
}
const String& encoding() const {
  DCHECK(hasEncoding());
return member_encoding_;
}
String getEncodingOr(const String& fallback_value) const;
String getEncodingOr(String&& fallback_value) const;
void setEncoding(const String& value);
void setEncoding(String&& value);

bool hasId() const {
  return has_id_;
}
const String& id() const {
  DCHECK(hasId());
return member_id_;
}
String getIdOr(const String& fallback_value) const;
String getIdOr(String&& fallback_value) const;
void setId(const String& value);
void setId(String&& value);

bool hasLang() const {
  return has_lang_;
}
const String& lang() const {
  DCHECK(hasLang());
return member_lang_;
}
String getLangOr(const String& fallback_value) const;
String getLangOr(String&& fallback_value) const;
void setLang(const String& value);
void setLang(String&& value);

bool hasMediaType() const {
  return has_media_type_;
}
const String& mediaType() const {
  DCHECK(hasMediaType());
return member_media_type_;
}
String getMediaTypeOr(const String& fallback_value) const;
String getMediaTypeOr(String&& fallback_value) const;
void setMediaType(const String& value);
void setMediaType(String&& value);

bool hasRecordType() const {
  return true;
}
const String& recordType() const {
  return member_record_type_;
}
void setRecordType(const String& value);
void setRecordType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_encoding_ = false;
bool has_id_ = false;
bool has_lang_ = false;
bool has_media_type_ = false;

ScriptValue member_data_;
String member_encoding_;
String member_id_;
String member_lang_;
String member_media_type_;
String member_record_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NDEF_RECORD_INIT_H_
