// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_WHERE_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_WHERE_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLTensorLimits;

class MODULES_EXPORT MLWhereSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLWhereSupportLimits* Create() {
  return MakeGarbageCollected<MLWhereSupportLimits>();
}
static MLWhereSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLWhereSupportLimits>(isolate);
}
static MLWhereSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLWhereSupportLimits();
explicit  MLWhereSupportLimits(v8::Isolate* isolate);

bool hasCondition() const {
  return has_condition_;
}
MLTensorLimits* condition() const {
  DCHECK(hasCondition());
return member_condition_.Get();
}
MLTensorLimits* getConditionOr(MLTensorLimits* fallback_value) const {
  if (!hasCondition()) {
  return fallback_value;
}
return member_condition_.Get();
}
void setCondition(MLTensorLimits* value) {
  member_condition_ = value;
has_condition_ = true;
DCHECK(member_condition_);
}

bool hasFalseValue() const {
  return has_false_value_;
}
MLTensorLimits* falseValue() const {
  DCHECK(hasFalseValue());
return member_false_value_.Get();
}
MLTensorLimits* getFalseValueOr(MLTensorLimits* fallback_value) const {
  if (!hasFalseValue()) {
  return fallback_value;
}
return member_false_value_.Get();
}
void setFalseValue(MLTensorLimits* value) {
  member_false_value_ = value;
has_false_value_ = true;
DCHECK(member_false_value_);
}

bool hasOutput() const {
  return has_output_;
}
MLTensorLimits* output() const {
  DCHECK(hasOutput());
return member_output_.Get();
}
MLTensorLimits* getOutputOr(MLTensorLimits* fallback_value) const {
  if (!hasOutput()) {
  return fallback_value;
}
return member_output_.Get();
}
void setOutput(MLTensorLimits* value) {
  member_output_ = value;
has_output_ = true;
DCHECK(member_output_);
}

bool hasTrueValue() const {
  return has_true_value_;
}
MLTensorLimits* trueValue() const {
  DCHECK(hasTrueValue());
return member_true_value_.Get();
}
MLTensorLimits* getTrueValueOr(MLTensorLimits* fallback_value) const {
  if (!hasTrueValue()) {
  return fallback_value;
}
return member_true_value_.Get();
}
void setTrueValue(MLTensorLimits* value) {
  member_true_value_ = value;
has_true_value_ = true;
DCHECK(member_true_value_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_condition_ = false;
bool has_false_value_ = false;
bool has_output_ = false;
bool has_true_value_ = false;

Member<MLTensorLimits> member_condition_;
Member<MLTensorLimits> member_false_value_;
Member<MLTensorLimits> member_output_;
Member<MLTensorLimits> member_true_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_WHERE_SUPPORT_LIMITS_H_
