// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OPERAND_DATA_TYPE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OPERAND_DATA_TYPE_H_

#include <optional>

#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/enumeration_base.h"  // IWYU pragma: export

namespace blink {

class ExceptionState;

class MODULES_EXPORT V8MLOperandDataType final : public bindings::EnumerationBase {
  
  public:
enum class Enum : enum_int_t {
kFloat32, kFloat16, kInt32, kUint32, kInt64, kUint64, kInt8, kUint8, kInt4, kUint4
};
static constexpr size_t kEnumSize = 10;

static V8MLOperandDataType Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state);
static std::optional<V8MLOperandDataType> Create(const String& value);

explicit constexpr  V8MLOperandDataType(Enum value) : bindings::EnumerationBase(static_cast<enum_int_t>(value), string_table_[static_cast<enum_int_t>(value)]) {
  
}
constexpr  V8MLOperandDataType(const V8MLOperandDataType&) = default;
constexpr  V8MLOperandDataType(V8MLOperandDataType&&) = default;
 ~V8MLOperandDataType() = default;

V8MLOperandDataType& operator=(const V8MLOperandDataType&) = default;
V8MLOperandDataType& operator=(V8MLOperandDataType&&) = default;

Enum AsEnum() const {
  return static_cast<Enum>(GetEnumValue());
}


  
  private:
static const char* const string_table_[];

constexpr  V8MLOperandDataType() = default;


  
};

inline bool operator==(const V8MLOperandDataType& lhs, V8MLOperandDataType::Enum rhs) {
  return lhs.AsEnum() == rhs;
}

inline bool operator==(V8MLOperandDataType::Enum lhs, const V8MLOperandDataType& rhs) {
  return lhs == rhs.AsEnum();
}


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OPERAND_DATA_TYPE_H_
