// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GEMM_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GEMM_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLOperand;

class MODULES_EXPORT MLGemmOptions : public MLOperatorOptions {
  
  public:
static MLGemmOptions* Create() {
  return MakeGarbageCollected<MLGemmOptions>();
}
static MLGemmOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLGemmOptions>(isolate);
}
static MLGemmOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLGemmOptions();
explicit  MLGemmOptions(v8::Isolate* isolate);

bool hasATranspose() const {
  return true;
}
bool aTranspose() const {
  return member_a_transpose_;
}
void setATranspose(bool value) {
  member_a_transpose_ = value;
}

bool hasAlpha() const {
  return true;
}
float alpha() const {
  return member_alpha_;
}
void setAlpha(float value) {
  member_alpha_ = value;
}

bool hasBTranspose() const {
  return true;
}
bool bTranspose() const {
  return member_b_transpose_;
}
void setBTranspose(bool value) {
  member_b_transpose_ = value;
}

bool hasBeta() const {
  return true;
}
float beta() const {
  return member_beta_;
}
void setBeta(float value) {
  member_beta_ = value;
}

bool hasC() const {
  return has_c_;
}
MLOperand* c() const {
  DCHECK(hasC());
return member_c_.Get();
}
MLOperand* getCOr(MLOperand* fallback_value) const {
  if (!hasC()) {
  return fallback_value;
}
return member_c_.Get();
}
void setC(MLOperand* value) {
  member_c_ = value;
has_c_ = true;
DCHECK(member_c_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_c_ = false;

bool member_a_transpose_{false};
float member_alpha_{1.0};
bool member_b_transpose_{false};
float member_beta_{1.0};
Member<MLOperand> member_c_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GEMM_OPTIONS_H_
