// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CUMULATIVE_SUM_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CUMULATIVE_SUM_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLCumulativeSumOptions : public MLOperatorOptions {
  
  public:
static MLCumulativeSumOptions* Create() {
  return MakeGarbageCollected<MLCumulativeSumOptions>();
}
static MLCumulativeSumOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLCumulativeSumOptions>(isolate);
}
static MLCumulativeSumOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLCumulativeSumOptions();
explicit  MLCumulativeSumOptions(v8::Isolate* isolate);

bool hasExclusive() const {
  return true;
}
bool exclusive() const {
  return member_exclusive_;
}
void setExclusive(bool value) {
  member_exclusive_ = value;
}

bool hasReversed() const {
  return true;
}
bool reversed() const {
  return member_reversed_;
}
void setReversed(bool value) {
  member_reversed_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_exclusive_{false};
bool member_reversed_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CUMULATIVE_SUM_OPTIONS_H_
