// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_METADATA_CALLBACK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_METADATA_CALLBACK_H_

#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/callback_interface_base.h"
#include "third_party/blink/renderer/platform/bindings/v8_value_or_script_wrappable_adapter.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Metadata;

class MODULES_EXPORT V8MetadataCallback final : public CallbackInterfaceBase {
  
  public:
static V8MetadataCallback* Create(v8::Local<v8::Object> callback_object) {
  return MakeGarbageCollected<V8MetadataCallback>(callback_object);
}

explicit  V8MetadataCallback(v8::Local<v8::Object> callback_object) : CallbackInterfaceBase(callback_object, kSingleOperation) {
  
}
 ~V8MetadataCallback() override = default;

// NameClient overrides:
const char* GetHumanReadableName() const override;

// Performs "call a user object's operation".
// https://webidl.spec.whatwg.org/#call-a-user-objects-operation
[[nodiscard]] v8::Maybe<void> handleEvent(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Metadata* arg1_metadata);

// Performs "call a user object's operation" and then reports an exception
// if any to the global error handler such as DevTools console.
void InvokeAndReportException(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Metadata* arg1_metadata);



  
  
  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_METADATA_CALLBACK_H_
