// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_settings.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_string.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_point_2d.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"aspectRatio",
"autoGainControl",
"backgroundBlur",
"backgroundSegmentationMask",
"brightness",
"channelCount",
"colorTemperature",
"contrast",
"cursor",
"deviceId",
"displaySurface",
"echoCancellation",
"exposureCompensation",
"exposureMode",
"exposureTime",
"eyeGazeCorrection",
"faceFraming",
"facingMode",
"focusDistance",
"focusMode",
"frameRate",
"groupId",
"height",
"iso",
"latency",
"logicalSurface",
"noiseSuppression",
"pan",
"pointsOfInterest",
"resizeMode",
"restrictOwnAudio",
"sampleRate",
"sampleSize",
"saturation",
"screenPixelRatio",
"sharpness",
"suppressLocalAudioPlayback",
"tilt",
"torch",
"voiceIsolation",
"whiteBalanceMode",
"width",
"zoom",
};


}  // namespace 

MediaTrackSettings* MediaTrackSettings::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MediaTrackSettings* dictionary = MakeGarbageCollected<MediaTrackSettings>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MediaTrackSettings";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MediaTrackSettings::MediaTrackSettings() {
  
}

 MediaTrackSettings::MediaTrackSettings(v8::Isolate* isolate) {
  
}



























































String MediaTrackSettings::getCursorOr(const String& fallback_value) const {
  if (!hasCursor()) {
  return fallback_value;
}
return member_cursor_;
}

String MediaTrackSettings::getCursorOr(String&& fallback_value) const {
  if (!hasCursor()) {
  return std::move(fallback_value);
}
return member_cursor_;
}

void MediaTrackSettings::setCursor(const String& value) {
  member_cursor_ = value;
has_cursor_ = true;
}

void MediaTrackSettings::setCursor(String&& value) {
  member_cursor_ = std::move(value);
has_cursor_ = true;
}




String MediaTrackSettings::getDeviceIdOr(const String& fallback_value) const {
  if (!hasDeviceId()) {
  return fallback_value;
}
return member_device_id_;
}

String MediaTrackSettings::getDeviceIdOr(String&& fallback_value) const {
  if (!hasDeviceId()) {
  return std::move(fallback_value);
}
return member_device_id_;
}

void MediaTrackSettings::setDeviceId(const String& value) {
  member_device_id_ = value;
has_device_id_ = true;
}

void MediaTrackSettings::setDeviceId(String&& value) {
  member_device_id_ = std::move(value);
has_device_id_ = true;
}




String MediaTrackSettings::getDisplaySurfaceOr(const String& fallback_value) const {
  if (!hasDisplaySurface()) {
  return fallback_value;
}
return member_display_surface_;
}

String MediaTrackSettings::getDisplaySurfaceOr(String&& fallback_value) const {
  if (!hasDisplaySurface()) {
  return std::move(fallback_value);
}
return member_display_surface_;
}

void MediaTrackSettings::setDisplaySurface(const String& value) {
  member_display_surface_ = value;
has_display_surface_ = true;
}

void MediaTrackSettings::setDisplaySurface(String&& value) {
  member_display_surface_ = std::move(value);
has_display_surface_ = true;
}


















String MediaTrackSettings::getExposureModeOr(const String& fallback_value) const {
  if (!hasExposureMode()) {
  return fallback_value;
}
return member_exposure_mode_;
}

String MediaTrackSettings::getExposureModeOr(String&& fallback_value) const {
  if (!hasExposureMode()) {
  return std::move(fallback_value);
}
return member_exposure_mode_;
}

void MediaTrackSettings::setExposureMode(const String& value) {
  member_exposure_mode_ = value;
has_exposure_mode_ = true;
}

void MediaTrackSettings::setExposureMode(String&& value) {
  member_exposure_mode_ = std::move(value);
has_exposure_mode_ = true;
}

























String MediaTrackSettings::getFacingModeOr(const String& fallback_value) const {
  if (!hasFacingMode()) {
  return fallback_value;
}
return member_facing_mode_;
}

String MediaTrackSettings::getFacingModeOr(String&& fallback_value) const {
  if (!hasFacingMode()) {
  return std::move(fallback_value);
}
return member_facing_mode_;
}

void MediaTrackSettings::setFacingMode(const String& value) {
  member_facing_mode_ = value;
has_facing_mode_ = true;
}

void MediaTrackSettings::setFacingMode(String&& value) {
  member_facing_mode_ = std::move(value);
has_facing_mode_ = true;
}











String MediaTrackSettings::getFocusModeOr(const String& fallback_value) const {
  if (!hasFocusMode()) {
  return fallback_value;
}
return member_focus_mode_;
}

String MediaTrackSettings::getFocusModeOr(String&& fallback_value) const {
  if (!hasFocusMode()) {
  return std::move(fallback_value);
}
return member_focus_mode_;
}

void MediaTrackSettings::setFocusMode(const String& value) {
  member_focus_mode_ = value;
has_focus_mode_ = true;
}

void MediaTrackSettings::setFocusMode(String&& value) {
  member_focus_mode_ = std::move(value);
has_focus_mode_ = true;
}











String MediaTrackSettings::getGroupIdOr(const String& fallback_value) const {
  if (!hasGroupId()) {
  return fallback_value;
}
return member_group_id_;
}

String MediaTrackSettings::getGroupIdOr(String&& fallback_value) const {
  if (!hasGroupId()) {
  return std::move(fallback_value);
}
return member_group_id_;
}

void MediaTrackSettings::setGroupId(const String& value) {
  member_group_id_ = value;
has_group_id_ = true;
}

void MediaTrackSettings::setGroupId(String&& value) {
  member_group_id_ = std::move(value);
has_group_id_ = true;
}














































HeapVector<Member<Point2D>> MediaTrackSettings::getPointsOfInterestOr(const HeapVector<Member<Point2D>>& fallback_value) const {
  if (!hasPointsOfInterest()) {
  return fallback_value;
}
return member_points_of_interest_;
}

HeapVector<Member<Point2D>> MediaTrackSettings::getPointsOfInterestOr(HeapVector<Member<Point2D>>&& fallback_value) const {
  if (!hasPointsOfInterest()) {
  return std::move(fallback_value);
}
return member_points_of_interest_;
}

void MediaTrackSettings::setPointsOfInterest(const HeapVector<Member<Point2D>>& value) {
  member_points_of_interest_ = value;
has_points_of_interest_ = true;
}

void MediaTrackSettings::setPointsOfInterest(HeapVector<Member<Point2D>>&& value) {
  member_points_of_interest_ = std::move(value);
has_points_of_interest_ = true;
}




String MediaTrackSettings::getResizeModeOr(const String& fallback_value) const {
  if (!hasResizeMode()) {
  return fallback_value;
}
return member_resize_mode_;
}

String MediaTrackSettings::getResizeModeOr(String&& fallback_value) const {
  if (!hasResizeMode()) {
  return std::move(fallback_value);
}
return member_resize_mode_;
}

void MediaTrackSettings::setResizeMode(const String& value) {
  member_resize_mode_ = value;
has_resize_mode_ = true;
}

void MediaTrackSettings::setResizeMode(String&& value) {
  member_resize_mode_ = std::move(value);
has_resize_mode_ = true;
}










































































String MediaTrackSettings::getWhiteBalanceModeOr(const String& fallback_value) const {
  if (!hasWhiteBalanceMode()) {
  return fallback_value;
}
return member_white_balance_mode_;
}

String MediaTrackSettings::getWhiteBalanceModeOr(String&& fallback_value) const {
  if (!hasWhiteBalanceMode()) {
  return std::move(fallback_value);
}
return member_white_balance_mode_;
}

void MediaTrackSettings::setWhiteBalanceMode(const String& value) {
  member_white_balance_mode_ = value;
has_white_balance_mode_ = true;
}

void MediaTrackSettings::setWhiteBalanceMode(String&& value) {
  member_white_balance_mode_ = std::move(value);
has_white_balance_mode_ = true;
}

















void MediaTrackSettings::Trace(Visitor* visitor) const {
  visitor->Trace(member_echo_cancellation_);
visitor->Trace(member_points_of_interest_);
bindings::DictionaryBase::Trace(visitor);
}

void MediaTrackSettings::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MediaTrackSettings::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAspectRatio()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_aspect_ratio_);
DCHECK(!values[0].IsEmpty());
}
if (hasAutoGainControl()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_auto_gain_control_);
DCHECK(!values[1].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  if (hasBackgroundBlur()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_background_blur_);
DCHECK(!values[2].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasBackgroundSegmentationMask()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_background_segmentation_mask_);
DCHECK(!values[3].IsEmpty());
}
}
if (hasBrightness()) {
  values[4] = ToV8Traits<IDLDouble>::ToV8(script_state, member_brightness_);
DCHECK(!values[4].IsEmpty());
}
if (hasChannelCount()) {
  values[5] = ToV8Traits<IDLLong>::ToV8(script_state, member_channel_count_);
DCHECK(!values[5].IsEmpty());
}
if (hasColorTemperature()) {
  values[6] = ToV8Traits<IDLDouble>::ToV8(script_state, member_color_temperature_);
DCHECK(!values[6].IsEmpty());
}
if (hasContrast()) {
  values[7] = ToV8Traits<IDLDouble>::ToV8(script_state, member_contrast_);
DCHECK(!values[7].IsEmpty());
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  if (hasCursor()) {
  values[8] = ToV8Traits<IDLString>::ToV8(script_state, member_cursor_);
DCHECK(!values[8].IsEmpty());
}
}
if (hasDeviceId()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_device_id_);
DCHECK(!values[9].IsEmpty());
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  if (hasDisplaySurface()) {
  values[10] = ToV8Traits<IDLString>::ToV8(script_state, member_display_surface_);
DCHECK(!values[10].IsEmpty());
}
}
if (hasEchoCancellation()) {
  values[11] = ToV8Traits<V8UnionBooleanOrString>::ToV8(script_state, member_echo_cancellation_.Get());
DCHECK(!values[11].IsEmpty());
}
if (hasExposureCompensation()) {
  values[12] = ToV8Traits<IDLDouble>::ToV8(script_state, member_exposure_compensation_);
DCHECK(!values[12].IsEmpty());
}
if (hasExposureMode()) {
  values[13] = ToV8Traits<IDLString>::ToV8(script_state, member_exposure_mode_);
DCHECK(!values[13].IsEmpty());
}
if (hasExposureTime()) {
  values[14] = ToV8Traits<IDLDouble>::ToV8(script_state, member_exposure_time_);
DCHECK(!values[14].IsEmpty());
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasEyeGazeCorrection()) {
  values[15] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_eye_gaze_correction_);
DCHECK(!values[15].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasFaceFraming()) {
  values[16] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_face_framing_);
DCHECK(!values[16].IsEmpty());
}
}
if (hasFacingMode()) {
  values[17] = ToV8Traits<IDLString>::ToV8(script_state, member_facing_mode_);
DCHECK(!values[17].IsEmpty());
}
if (hasFocusDistance()) {
  values[18] = ToV8Traits<IDLDouble>::ToV8(script_state, member_focus_distance_);
DCHECK(!values[18].IsEmpty());
}
if (hasFocusMode()) {
  values[19] = ToV8Traits<IDLString>::ToV8(script_state, member_focus_mode_);
DCHECK(!values[19].IsEmpty());
}
if (hasFrameRate()) {
  values[20] = ToV8Traits<IDLDouble>::ToV8(script_state, member_frame_rate_);
DCHECK(!values[20].IsEmpty());
}
if (hasGroupId()) {
  values[21] = ToV8Traits<IDLString>::ToV8(script_state, member_group_id_);
DCHECK(!values[21].IsEmpty());
}
if (hasHeight()) {
  values[22] = ToV8Traits<IDLLong>::ToV8(script_state, member_height_);
DCHECK(!values[22].IsEmpty());
}
if (hasIso()) {
  values[23] = ToV8Traits<IDLDouble>::ToV8(script_state, member_iso_);
DCHECK(!values[23].IsEmpty());
}
if (hasLatency()) {
  values[24] = ToV8Traits<IDLDouble>::ToV8(script_state, member_latency_);
DCHECK(!values[24].IsEmpty());
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  if (hasLogicalSurface()) {
  values[25] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_logical_surface_);
DCHECK(!values[25].IsEmpty());
}
}
if (hasNoiseSuppression()) {
  values[26] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_noise_suppression_);
DCHECK(!values[26].IsEmpty());
}
if (hasPan()) {
  values[27] = ToV8Traits<IDLDouble>::ToV8(script_state, member_pan_);
DCHECK(!values[27].IsEmpty());
}
if (hasPointsOfInterest()) {
  values[28] = ToV8Traits<IDLSequence<Point2D>>::ToV8(script_state, member_points_of_interest_);
DCHECK(!values[28].IsEmpty());
}
if (hasResizeMode()) {
  values[29] = ToV8Traits<IDLString>::ToV8(script_state, member_resize_mode_);
DCHECK(!values[29].IsEmpty());
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  if (hasRestrictOwnAudio()) {
  values[30] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_restrict_own_audio_);
DCHECK(!values[30].IsEmpty());
}
}
if (hasSampleRate()) {
  values[31] = ToV8Traits<IDLLong>::ToV8(script_state, member_sample_rate_);
DCHECK(!values[31].IsEmpty());
}
if (hasSampleSize()) {
  values[32] = ToV8Traits<IDLLong>::ToV8(script_state, member_sample_size_);
DCHECK(!values[32].IsEmpty());
}
if (hasSaturation()) {
  values[33] = ToV8Traits<IDLDouble>::ToV8(script_state, member_saturation_);
DCHECK(!values[33].IsEmpty());
}
if (RuntimeEnabledFeatures::CapturedSurfaceResolutionEnabled()) {
  if (hasScreenPixelRatio()) {
  values[34] = ToV8Traits<IDLDouble>::ToV8(script_state, member_screen_pixel_ratio_);
DCHECK(!values[34].IsEmpty());
}
}
if (hasSharpness()) {
  values[35] = ToV8Traits<IDLDouble>::ToV8(script_state, member_sharpness_);
DCHECK(!values[35].IsEmpty());
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  if (hasSuppressLocalAudioPlayback()) {
  values[36] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_suppress_local_audio_playback_);
DCHECK(!values[36].IsEmpty());
}
}
if (hasTilt()) {
  values[37] = ToV8Traits<IDLDouble>::ToV8(script_state, member_tilt_);
DCHECK(!values[37].IsEmpty());
}
if (hasTorch()) {
  values[38] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_torch_);
DCHECK(!values[38].IsEmpty());
}
if (hasVoiceIsolation()) {
  values[39] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_voice_isolation_);
DCHECK(!values[39].IsEmpty());
}
if (hasWhiteBalanceMode()) {
  values[40] = ToV8Traits<IDLString>::ToV8(script_state, member_white_balance_mode_);
DCHECK(!values[40].IsEmpty());
}
if (hasWidth()) {
  values[41] = ToV8Traits<IDLLong>::ToV8(script_state, member_width_);
DCHECK(!values[41].IsEmpty());
}
if (hasZoom()) {
  values[42] = ToV8Traits<IDLDouble>::ToV8(script_state, member_zoom_);
DCHECK(!values[42].IsEmpty());
}
}

const void* MediaTrackSettings::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MediaTrackSettings::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MediaTrackSettings::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MediaTrackSettings";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("aspectRatio");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_aspect_ratio_, member_aspect_ratio_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("autoGainControl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_auto_gain_control_, member_auto_gain_control_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundBlur");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_background_blur_, member_background_blur_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundSegmentationMask");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_background_segmentation_mask_, member_background_segmentation_mask_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("brightness");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_brightness_, member_brightness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("channelCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_channel_count_, member_channel_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorTemperature");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_color_temperature_, member_color_temperature_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contrast");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_contrast_, member_contrast_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("cursor");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_cursor_, member_cursor_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("deviceId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_device_id_, member_device_id_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("displaySurface");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_display_surface_, member_display_surface_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("echoCancellation");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionBooleanOrString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_echo_cancellation_, member_echo_cancellation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureCompensation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_exposure_compensation_, member_exposure_compensation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_exposure_mode_, member_exposure_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_exposure_time_, member_exposure_time_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("eyeGazeCorrection");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_eye_gaze_correction_, member_eye_gaze_correction_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("faceFraming");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_face_framing_, member_face_framing_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("facingMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_facing_mode_, member_facing_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusDistance");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_focus_distance_, member_focus_distance_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_focus_mode_, member_focus_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_frame_rate_, member_frame_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("groupId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_group_id_, member_group_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_height_, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iso");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_iso_, member_iso_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("latency");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_latency_, member_latency_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("logicalSurface");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_logical_surface_, member_logical_surface_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("noiseSuppression");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_noise_suppression_, member_noise_suppression_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pan");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_pan_, member_pan_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pointsOfInterest");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<Point2D>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_points_of_interest_, member_points_of_interest_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_resize_mode_, member_resize_mode_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("restrictOwnAudio");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_restrict_own_audio_, member_restrict_own_audio_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), has_sample_rate_, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleSize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), has_sample_size_, member_sample_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("saturation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_saturation_, member_saturation_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::CapturedSurfaceResolutionEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("screenPixelRatio");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_screen_pixel_ratio_, member_screen_pixel_ratio_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sharpness");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), has_sharpness_, member_sharpness_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("suppressLocalAudioPlayback");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), has_suppress_local_audio_playback_, member_suppress_local_audio_playback_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("tilt");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), has_tilt_, member_tilt_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("torch");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[38].Get(isolate), has_torch_, member_torch_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("voiceIsolation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[39].Get(isolate), has_voice_isolation_, member_voice_isolation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("whiteBalanceMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[40].Get(isolate), has_white_balance_mode_, member_white_balance_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[41].Get(isolate), has_width_, member_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("zoom");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[42].Get(isolate), has_zoom_, member_zoom_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MediaTrackSettings::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
