// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaStream;

class MODULES_EXPORT MediaStreamEventInit : public EventInit {
  
  public:
static MediaStreamEventInit* Create() {
  return MakeGarbageCollected<MediaStreamEventInit>();
}
static MediaStreamEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaStreamEventInit>(isolate);
}
static MediaStreamEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaStreamEventInit();
explicit  MediaStreamEventInit(v8::Isolate* isolate);

bool hasStream() const {
  return has_stream_;
}
MediaStream* stream() const {
  DCHECK(hasStream());
return member_stream_.Get();
}
MediaStream* getStreamOr(MediaStream* fallback_value) const {
  if (!hasStream()) {
  return fallback_value;
}
return member_stream_.Get();
}
void setStream(MediaStream* value) {
  member_stream_ = value;
has_stream_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_stream_ = false;

Member<MediaStream> member_stream_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_EVENT_INIT_H_
