// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_media_capabilities_key_system_configuration.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_key_system_track_configuration.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"audio",
"distinctiveIdentifier",
"initDataType",
"keySystem",
"persistentState",
"sessionTypes",
"video",
};


}  // namespace 

MediaCapabilitiesKeySystemConfiguration* MediaCapabilitiesKeySystemConfiguration::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MediaCapabilitiesKeySystemConfiguration* dictionary = MakeGarbageCollected<MediaCapabilitiesKeySystemConfiguration>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MediaCapabilitiesKeySystemConfiguration";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MediaCapabilitiesKeySystemConfiguration::MediaCapabilitiesKeySystemConfiguration() {
  
}

 MediaCapabilitiesKeySystemConfiguration::MediaCapabilitiesKeySystemConfiguration(v8::Isolate* isolate) {
  
}















void MediaCapabilitiesKeySystemConfiguration::setInitDataType(const String& value) {
  member_init_data_type_ = value;
}

void MediaCapabilitiesKeySystemConfiguration::setInitDataType(String&& value) {
  member_init_data_type_ = std::move(value);
}




void MediaCapabilitiesKeySystemConfiguration::setKeySystem(const String& value) {
  member_key_system_ = value;
}

void MediaCapabilitiesKeySystemConfiguration::setKeySystem(String&& value) {
  member_key_system_ = std::move(value);
}









Vector<String> MediaCapabilitiesKeySystemConfiguration::getSessionTypesOr(const Vector<String>& fallback_value) const {
  if (!hasSessionTypes()) {
  return fallback_value;
}
return member_session_types_;
}

Vector<String> MediaCapabilitiesKeySystemConfiguration::getSessionTypesOr(Vector<String>&& fallback_value) const {
  if (!hasSessionTypes()) {
  return std::move(fallback_value);
}
return member_session_types_;
}

void MediaCapabilitiesKeySystemConfiguration::setSessionTypes(const Vector<String>& value) {
  member_session_types_ = value;
has_session_types_ = true;
}

void MediaCapabilitiesKeySystemConfiguration::setSessionTypes(Vector<String>&& value) {
  member_session_types_ = std::move(value);
has_session_types_ = true;
}










void MediaCapabilitiesKeySystemConfiguration::Trace(Visitor* visitor) const {
  visitor->Trace(member_audio_);
visitor->Trace(member_video_);
bindings::InputDictionaryBase::Trace(visitor);
}

void MediaCapabilitiesKeySystemConfiguration::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MediaCapabilitiesKeySystemConfiguration";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("audio");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<KeySystemTrackConfiguration, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_audio_, member_audio_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("distinctiveIdentifier");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8MediaKeysRequirement, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_distinctive_identifier_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("initDataType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_init_data_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keySystem");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_key_system_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("persistentState");
if (!bindings::GetDictionaryMemberFromV8Object<V8MediaKeysRequirement, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_persistent_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sessionTypes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_session_types_, member_session_types_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("video");
if (!bindings::GetDictionaryMemberFromV8Object<KeySystemTrackConfiguration, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_video_, member_video_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MediaCapabilitiesKeySystemConfiguration::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
