// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_tool_result_type.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"

namespace blink {



constexpr const char* const V8LanguageModelToolResultType::string_table_[] = {
"text", "image", "audio", "object"
};

V8LanguageModelToolResultType V8LanguageModelToolResultType::Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state) {
  const auto& result = bindings::FindIndexInEnumStringTable(isolate, value, string_table_, "LanguageModelToolResultType", exception_state);
return result.has_value() ? V8LanguageModelToolResultType(static_cast<Enum>(result.value())) : V8LanguageModelToolResultType();
}

std::optional<V8LanguageModelToolResultType> V8LanguageModelToolResultType::Create(const String& value) {
  const auto& result = bindings::FindIndexInEnumStringTable(value, string_table_);
if (!result)
  return std::nullopt;
return V8LanguageModelToolResultType(static_cast<Enum>(result.value()));
}


static_assert(std::is_trivially_copyable<V8LanguageModelToolResultType>::value, "");






}  // namespace blink
