// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_TOOL_RESULT_CONTENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_TOOL_RESULT_CONTENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_tool_result_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT LanguageModelToolResultContent : public bindings::DictionaryBase {
  
  public:
static LanguageModelToolResultContent* Create() {
  return MakeGarbageCollected<LanguageModelToolResultContent>();
}
static LanguageModelToolResultContent* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LanguageModelToolResultContent>(isolate);
}
static LanguageModelToolResultContent* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LanguageModelToolResultContent();
explicit  LanguageModelToolResultContent(v8::Isolate* isolate);

bool hasType() const {
  return true;
}
V8LanguageModelToolResultType type() const {
  return member_type_;
}
void setType(V8LanguageModelToolResultType value) {
  member_type_ = value;
}
void setType(V8LanguageModelToolResultType::Enum value) {
  member_type_ = V8LanguageModelToolResultType(value);
}

bool hasValue() const {
  return true;
}
const ScriptValue& value() const {
  return member_value_;
}
void setValue(const ScriptValue& value) {
  member_value_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8LanguageModelToolResultType member_type_{static_cast<V8LanguageModelToolResultType::Enum>(0)};
ScriptValue member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_TOOL_RESULT_CONTENT_H_
