// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_TOOL_DECLARATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_TOOL_DECLARATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT LanguageModelToolDeclaration : public bindings::InputDictionaryBase {
  
  public:
static LanguageModelToolDeclaration* Create() {
  return MakeGarbageCollected<LanguageModelToolDeclaration>();
}
static LanguageModelToolDeclaration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LanguageModelToolDeclaration>(isolate);
}
static LanguageModelToolDeclaration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LanguageModelToolDeclaration();
explicit  LanguageModelToolDeclaration(v8::Isolate* isolate);

bool hasDescription() const {
  return true;
}
const String& description() const {
  return member_description_;
}
void setDescription(const String& value);
void setDescription(String&& value);

bool hasInputSchema() const {
  return true;
}
const ScriptObject& inputSchema() const {
  return member_input_schema_;
}
void setInputSchema(const ScriptObject& value) {
  member_input_schema_ = value;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_description_;
ScriptObject member_input_schema_;
String member_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_TOOL_DECLARATION_H_
