// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_create_core_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_expected.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_tool_declaration.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"expectedInputs",
"expectedOutputs",
"temperature",
"tools",
"topK",
};


}  // namespace 

LanguageModelCreateCoreOptions* LanguageModelCreateCoreOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  LanguageModelCreateCoreOptions* dictionary = MakeGarbageCollected<LanguageModelCreateCoreOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "LanguageModelCreateCoreOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 LanguageModelCreateCoreOptions::LanguageModelCreateCoreOptions() {
  
}

 LanguageModelCreateCoreOptions::LanguageModelCreateCoreOptions(v8::Isolate* isolate) {
  
}



HeapVector<Member<LanguageModelExpected>> LanguageModelCreateCoreOptions::getExpectedInputsOr(const HeapVector<Member<LanguageModelExpected>>& fallback_value) const {
  if (!hasExpectedInputs()) {
  return fallback_value;
}
return member_expected_inputs_;
}

HeapVector<Member<LanguageModelExpected>> LanguageModelCreateCoreOptions::getExpectedInputsOr(HeapVector<Member<LanguageModelExpected>>&& fallback_value) const {
  if (!hasExpectedInputs()) {
  return std::move(fallback_value);
}
return member_expected_inputs_;
}

void LanguageModelCreateCoreOptions::setExpectedInputs(const HeapVector<Member<LanguageModelExpected>>& value) {
  member_expected_inputs_ = value;
has_expected_inputs_ = true;
}

void LanguageModelCreateCoreOptions::setExpectedInputs(HeapVector<Member<LanguageModelExpected>>&& value) {
  member_expected_inputs_ = std::move(value);
has_expected_inputs_ = true;
}




HeapVector<Member<LanguageModelExpected>> LanguageModelCreateCoreOptions::getExpectedOutputsOr(const HeapVector<Member<LanguageModelExpected>>& fallback_value) const {
  if (!hasExpectedOutputs()) {
  return fallback_value;
}
return member_expected_outputs_;
}

HeapVector<Member<LanguageModelExpected>> LanguageModelCreateCoreOptions::getExpectedOutputsOr(HeapVector<Member<LanguageModelExpected>>&& fallback_value) const {
  if (!hasExpectedOutputs()) {
  return std::move(fallback_value);
}
return member_expected_outputs_;
}

void LanguageModelCreateCoreOptions::setExpectedOutputs(const HeapVector<Member<LanguageModelExpected>>& value) {
  member_expected_outputs_ = value;
has_expected_outputs_ = true;
}

void LanguageModelCreateCoreOptions::setExpectedOutputs(HeapVector<Member<LanguageModelExpected>>&& value) {
  member_expected_outputs_ = std::move(value);
has_expected_outputs_ = true;
}











HeapVector<Member<LanguageModelToolDeclaration>> LanguageModelCreateCoreOptions::getToolsOr(const HeapVector<Member<LanguageModelToolDeclaration>>& fallback_value) const {
  if (!hasTools()) {
  return fallback_value;
}
return member_tools_;
}

HeapVector<Member<LanguageModelToolDeclaration>> LanguageModelCreateCoreOptions::getToolsOr(HeapVector<Member<LanguageModelToolDeclaration>>&& fallback_value) const {
  if (!hasTools()) {
  return std::move(fallback_value);
}
return member_tools_;
}

void LanguageModelCreateCoreOptions::setTools(const HeapVector<Member<LanguageModelToolDeclaration>>& value) {
  member_tools_ = value;
has_tools_ = true;
}

void LanguageModelCreateCoreOptions::setTools(HeapVector<Member<LanguageModelToolDeclaration>>&& value) {
  member_tools_ = std::move(value);
has_tools_ = true;
}










void LanguageModelCreateCoreOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_expected_inputs_);
visitor->Trace(member_expected_outputs_);
visitor->Trace(member_tools_);
bindings::InputDictionaryBase::Trace(visitor);
}

void LanguageModelCreateCoreOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "LanguageModelCreateCoreOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("expectedInputs");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<LanguageModelExpected>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_expected_inputs_, member_expected_inputs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("expectedOutputs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<LanguageModelExpected>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_expected_outputs_, member_expected_outputs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("temperature");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_temperature_, member_temperature_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tools");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<LanguageModelToolDeclaration>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_tools_, member_tools_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("topK");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_top_k_, member_top_k_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> LanguageModelCreateCoreOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
