// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_item_details.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_currency_amount.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"description",
"freeTrialPeriod",
"iconURLs",
"introductoryPrice",
"introductoryPriceCycles",
"introductoryPricePeriod",
"itemId",
"price",
"subscriptionPeriod",
"title",
"type",
};


}  // namespace 

ItemDetails* ItemDetails::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ItemDetails* dictionary = MakeGarbageCollected<ItemDetails>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ItemDetails";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ItemDetails::ItemDetails() {
  
}

 ItemDetails::ItemDetails(v8::Isolate* isolate) {
  
}



String ItemDetails::getDescriptionOr(const String& fallback_value) const {
  if (!hasDescription()) {
  return fallback_value;
}
return member_description_;
}

String ItemDetails::getDescriptionOr(String&& fallback_value) const {
  if (!hasDescription()) {
  return std::move(fallback_value);
}
return member_description_;
}

void ItemDetails::setDescription(const String& value) {
  member_description_ = value;
has_description_ = true;
}

void ItemDetails::setDescription(String&& value) {
  member_description_ = std::move(value);
has_description_ = true;
}




String ItemDetails::getFreeTrialPeriodOr(const String& fallback_value) const {
  if (!hasFreeTrialPeriod()) {
  return fallback_value;
}
return member_free_trial_period_;
}

String ItemDetails::getFreeTrialPeriodOr(String&& fallback_value) const {
  if (!hasFreeTrialPeriod()) {
  return std::move(fallback_value);
}
return member_free_trial_period_;
}

void ItemDetails::setFreeTrialPeriod(const String& value) {
  member_free_trial_period_ = value;
has_free_trial_period_ = true;
}

void ItemDetails::setFreeTrialPeriod(String&& value) {
  member_free_trial_period_ = std::move(value);
has_free_trial_period_ = true;
}




Vector<String> ItemDetails::getIconURLsOr(const Vector<String>& fallback_value) const {
  if (!hasIconURLs()) {
  return fallback_value;
}
return member_icon_urls_;
}

Vector<String> ItemDetails::getIconURLsOr(Vector<String>&& fallback_value) const {
  if (!hasIconURLs()) {
  return std::move(fallback_value);
}
return member_icon_urls_;
}

void ItemDetails::setIconURLs(const Vector<String>& value) {
  member_icon_urls_ = value;
has_icon_urls_ = true;
}

void ItemDetails::setIconURLs(Vector<String>&& value) {
  member_icon_urls_ = std::move(value);
has_icon_urls_ = true;
}


















String ItemDetails::getIntroductoryPricePeriodOr(const String& fallback_value) const {
  if (!hasIntroductoryPricePeriod()) {
  return fallback_value;
}
return member_introductory_price_period_;
}

String ItemDetails::getIntroductoryPricePeriodOr(String&& fallback_value) const {
  if (!hasIntroductoryPricePeriod()) {
  return std::move(fallback_value);
}
return member_introductory_price_period_;
}

void ItemDetails::setIntroductoryPricePeriod(const String& value) {
  member_introductory_price_period_ = value;
has_introductory_price_period_ = true;
}

void ItemDetails::setIntroductoryPricePeriod(String&& value) {
  member_introductory_price_period_ = std::move(value);
has_introductory_price_period_ = true;
}




void ItemDetails::setItemId(const String& value) {
  member_item_id_ = value;
}

void ItemDetails::setItemId(String&& value) {
  member_item_id_ = std::move(value);
}









String ItemDetails::getSubscriptionPeriodOr(const String& fallback_value) const {
  if (!hasSubscriptionPeriod()) {
  return fallback_value;
}
return member_subscription_period_;
}

String ItemDetails::getSubscriptionPeriodOr(String&& fallback_value) const {
  if (!hasSubscriptionPeriod()) {
  return std::move(fallback_value);
}
return member_subscription_period_;
}

void ItemDetails::setSubscriptionPeriod(const String& value) {
  member_subscription_period_ = value;
has_subscription_period_ = true;
}

void ItemDetails::setSubscriptionPeriod(String&& value) {
  member_subscription_period_ = std::move(value);
has_subscription_period_ = true;
}




void ItemDetails::setTitle(const String& value) {
  member_title_ = value;
}

void ItemDetails::setTitle(String&& value) {
  member_title_ = std::move(value);
}










void ItemDetails::Trace(Visitor* visitor) const {
  visitor->Trace(member_introductory_price_);
visitor->Trace(member_price_);
bindings::DictionaryBase::Trace(visitor);
}

void ItemDetails::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ItemDetails::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDescription()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_description_);
DCHECK(!values[0].IsEmpty());
}
if (hasFreeTrialPeriod()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_free_trial_period_);
DCHECK(!values[1].IsEmpty());
}
if (RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled()) {
  if (hasIconURLs()) {
  values[2] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_icon_urls_);
DCHECK(!values[2].IsEmpty());
}
}
if (hasIntroductoryPrice()) {
  values[3] = ToV8Traits<PaymentCurrencyAmount>::ToV8(script_state, member_introductory_price_.Get());
DCHECK(!values[3].IsEmpty());
}
if (RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled()) {
  if (hasIntroductoryPriceCycles()) {
  values[4] = ToV8Traits<IDLUnsignedLongLongEnforceRange>::ToV8(script_state, member_introductory_price_cycles_);
DCHECK(!values[4].IsEmpty());
}
}
if (hasIntroductoryPricePeriod()) {
  values[5] = ToV8Traits<IDLString>::ToV8(script_state, member_introductory_price_period_);
DCHECK(!values[5].IsEmpty());
}
if (hasItemId()) {
  values[6] = ToV8Traits<IDLString>::ToV8(script_state, member_item_id_);
DCHECK(!values[6].IsEmpty());
}
if (hasPrice()) {
  values[7] = ToV8Traits<PaymentCurrencyAmount>::ToV8(script_state, member_price_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasSubscriptionPeriod()) {
  values[8] = ToV8Traits<IDLString>::ToV8(script_state, member_subscription_period_);
DCHECK(!values[8].IsEmpty());
}
if (hasTitle()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_title_);
DCHECK(!values[9].IsEmpty());
}
if (RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled()) {
  if (hasType()) {
  values[10] = ToV8Traits<V8ItemType>::ToV8(script_state, member_type_);
DCHECK(!values[10].IsEmpty());
}
}
}

const void* ItemDetails::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ItemDetails::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ItemDetails::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ItemDetails";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("description");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_description_, member_description_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("freeTrialPeriod");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_free_trial_period_, member_free_trial_period_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("iconURLs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_icon_urls_, member_icon_urls_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("introductoryPrice");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentCurrencyAmount, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_introductory_price_, member_introductory_price_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("introductoryPriceCycles");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_introductory_price_cycles_, member_introductory_price_cycles_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("introductoryPricePeriod");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_introductory_price_period_, member_introductory_price_period_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("itemId");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_item_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("price");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentCurrencyAmount, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_price_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("subscriptionPeriod");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_subscription_period_, member_subscription_period_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("title");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_title_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8ItemType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> ItemDetails::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
