// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_INK_TRAIL_STYLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_INK_TRAIL_STYLE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT InkTrailStyle : public bindings::InputDictionaryBase {
  
  public:
static InkTrailStyle* Create() {
  return MakeGarbageCollected<InkTrailStyle>();
}
static InkTrailStyle* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<InkTrailStyle>(isolate);
}
static InkTrailStyle* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  InkTrailStyle();
explicit  InkTrailStyle(v8::Isolate* isolate);

bool hasColor() const {
  return has_color_;
}
const String& color() const {
  DCHECK(hasColor());
return member_color_;
}
String getColorOr(const String& fallback_value) const;
String getColorOr(String&& fallback_value) const;
void setColor(const String& value);
void setColor(String&& value);

bool hasDiameter() const {
  return has_diameter_;
}
double diameter() const {
  DCHECK(hasDiameter());
return member_diameter_;
}
double getDiameterOr(double fallback_value) const {
  if (!hasDiameter()) {
  return fallback_value;
}
return member_diameter_;
}
void setDiameter(double value) {
  member_diameter_ = value;
has_diameter_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_color_ = false;
bool has_diameter_ = false;

String member_color_;
double member_diameter_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_INK_TRAIL_STYLE_H_
