// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_INK_PRESENTER_PARAM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_INK_PRESENTER_PARAM_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Element;
class ExceptionState;

class MODULES_EXPORT InkPresenterParam : public bindings::InputDictionaryBase {
  
  public:
static InkPresenterParam* Create() {
  return MakeGarbageCollected<InkPresenterParam>();
}
static InkPresenterParam* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<InkPresenterParam>(isolate);
}
static InkPresenterParam* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  InkPresenterParam();
explicit  InkPresenterParam(v8::Isolate* isolate);

bool hasPresentationArea() const {
  return true;
}
Element* presentationArea() const {
  return member_presentation_area_.Get();
}
void setPresentationArea(Element* value) {
  member_presentation_area_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<Element> member_presentation_area_{nullptr};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_INK_PRESENTER_PARAM_H_
