// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IMAGE_DECODER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IMAGE_DECODER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_color_space_conversion.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ReadableStream;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream;

class MODULES_EXPORT ImageDecoderInit : public bindings::InputDictionaryBase {
  
  public:
static ImageDecoderInit* Create() {
  return MakeGarbageCollected<ImageDecoderInit>();
}
static ImageDecoderInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ImageDecoderInit>(isolate);
}
static ImageDecoderInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ImageDecoderInit();
explicit  ImageDecoderInit(v8::Isolate* isolate);

bool hasColorSpaceConversion() const {
  return true;
}
V8ColorSpaceConversion colorSpaceConversion() const {
  return member_color_space_conversion_;
}
void setColorSpaceConversion(V8ColorSpaceConversion value) {
  member_color_space_conversion_ = value;
}
void setColorSpaceConversion(V8ColorSpaceConversion::Enum value) {
  member_color_space_conversion_ = V8ColorSpaceConversion(value);
}

bool hasData() const {
  return true;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream* data() const {
  return member_data_.Get();
}
void setData(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream* value) {
  member_data_ = value;
DCHECK(member_data_);
}

bool hasDesiredHeight() const {
  return has_desired_height_;
}
uint32_t desiredHeight() const {
  DCHECK(hasDesiredHeight());
return member_desired_height_;
}
uint32_t getDesiredHeightOr(uint32_t fallback_value) const {
  if (!hasDesiredHeight()) {
  return fallback_value;
}
return member_desired_height_;
}
void setDesiredHeight(uint32_t value) {
  member_desired_height_ = value;
has_desired_height_ = true;
}

bool hasDesiredWidth() const {
  return has_desired_width_;
}
uint32_t desiredWidth() const {
  DCHECK(hasDesiredWidth());
return member_desired_width_;
}
uint32_t getDesiredWidthOr(uint32_t fallback_value) const {
  if (!hasDesiredWidth()) {
  return fallback_value;
}
return member_desired_width_;
}
void setDesiredWidth(uint32_t value) {
  member_desired_width_ = value;
has_desired_width_ = true;
}

bool hasPreferAnimation() const {
  return has_prefer_animation_;
}
bool preferAnimation() const {
  DCHECK(hasPreferAnimation());
return member_prefer_animation_;
}
bool getPreferAnimationOr(bool fallback_value) const {
  if (!hasPreferAnimation()) {
  return fallback_value;
}
return member_prefer_animation_;
}
void setPreferAnimation(bool value) {
  member_prefer_animation_ = value;
has_prefer_animation_ = true;
}

bool hasTransfer() const {
  return true;
}
const HeapVector<Member<DOMArrayBuffer>>& transfer() const {
  return member_transfer_;
}
void setTransfer(const HeapVector<Member<DOMArrayBuffer>>& value);
void setTransfer(HeapVector<Member<DOMArrayBuffer>>&& value);

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_desired_height_ = false;
bool has_desired_width_ = false;
bool has_prefer_animation_ = false;

V8ColorSpaceConversion member_color_space_conversion_{V8ColorSpaceConversion::Enum::kDefault};
Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowSharedOrReadableStream> member_data_;
uint32_t member_desired_height_;
uint32_t member_desired_width_;
bool member_prefer_animation_;
HeapVector<Member<DOMArrayBuffer>> member_transfer_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IMAGE_DECODER_INIT_H_
