// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_account.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"approved_clients",
"domain_hints",
"email",
"given_name",
"id",
"login_hints",
"name",
"picture",
};


}  // namespace 

IdentityProviderAccount* IdentityProviderAccount::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  IdentityProviderAccount* dictionary = MakeGarbageCollected<IdentityProviderAccount>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "IdentityProviderAccount";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 IdentityProviderAccount::IdentityProviderAccount() {
  
}

 IdentityProviderAccount::IdentityProviderAccount(v8::Isolate* isolate) {
  
}



Vector<String> IdentityProviderAccount::getApprovedClientsOr(const Vector<String>& fallback_value) const {
  if (!hasApprovedClients()) {
  return fallback_value;
}
return member_approved_clients_;
}

Vector<String> IdentityProviderAccount::getApprovedClientsOr(Vector<String>&& fallback_value) const {
  if (!hasApprovedClients()) {
  return std::move(fallback_value);
}
return member_approved_clients_;
}

void IdentityProviderAccount::setApprovedClients(const Vector<String>& value) {
  member_approved_clients_ = value;
has_approved_clients_ = true;
}

void IdentityProviderAccount::setApprovedClients(Vector<String>&& value) {
  member_approved_clients_ = std::move(value);
has_approved_clients_ = true;
}




Vector<String> IdentityProviderAccount::getDomainHintsOr(const Vector<String>& fallback_value) const {
  if (!hasDomainHints()) {
  return fallback_value;
}
return member_domain_hints_;
}

Vector<String> IdentityProviderAccount::getDomainHintsOr(Vector<String>&& fallback_value) const {
  if (!hasDomainHints()) {
  return std::move(fallback_value);
}
return member_domain_hints_;
}

void IdentityProviderAccount::setDomainHints(const Vector<String>& value) {
  member_domain_hints_ = value;
has_domain_hints_ = true;
}

void IdentityProviderAccount::setDomainHints(Vector<String>&& value) {
  member_domain_hints_ = std::move(value);
has_domain_hints_ = true;
}




void IdentityProviderAccount::setEmail(const String& value) {
  member_email_ = value;
}

void IdentityProviderAccount::setEmail(String&& value) {
  member_email_ = std::move(value);
}




String IdentityProviderAccount::getGivenNameOr(const String& fallback_value) const {
  if (!hasGivenName()) {
  return fallback_value;
}
return member_given_name_;
}

String IdentityProviderAccount::getGivenNameOr(String&& fallback_value) const {
  if (!hasGivenName()) {
  return std::move(fallback_value);
}
return member_given_name_;
}

void IdentityProviderAccount::setGivenName(const String& value) {
  member_given_name_ = value;
has_given_name_ = true;
}

void IdentityProviderAccount::setGivenName(String&& value) {
  member_given_name_ = std::move(value);
has_given_name_ = true;
}




void IdentityProviderAccount::setId(const String& value) {
  member_id_ = value;
}

void IdentityProviderAccount::setId(String&& value) {
  member_id_ = std::move(value);
}




Vector<String> IdentityProviderAccount::getLoginHintsOr(const Vector<String>& fallback_value) const {
  if (!hasLoginHints()) {
  return fallback_value;
}
return member_login_hints_;
}

Vector<String> IdentityProviderAccount::getLoginHintsOr(Vector<String>&& fallback_value) const {
  if (!hasLoginHints()) {
  return std::move(fallback_value);
}
return member_login_hints_;
}

void IdentityProviderAccount::setLoginHints(const Vector<String>& value) {
  member_login_hints_ = value;
has_login_hints_ = true;
}

void IdentityProviderAccount::setLoginHints(Vector<String>&& value) {
  member_login_hints_ = std::move(value);
has_login_hints_ = true;
}




void IdentityProviderAccount::setName(const String& value) {
  member_name_ = value;
}

void IdentityProviderAccount::setName(String&& value) {
  member_name_ = std::move(value);
}




String IdentityProviderAccount::getPictureOr(const String& fallback_value) const {
  if (!hasPicture()) {
  return fallback_value;
}
return member_picture_;
}

String IdentityProviderAccount::getPictureOr(String&& fallback_value) const {
  if (!hasPicture()) {
  return std::move(fallback_value);
}
return member_picture_;
}

void IdentityProviderAccount::setPicture(const String& value) {
  member_picture_ = value;
has_picture_ = true;
}

void IdentityProviderAccount::setPicture(String&& value) {
  member_picture_ = std::move(value);
has_picture_ = true;
}



void IdentityProviderAccount::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void IdentityProviderAccount::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "IdentityProviderAccount";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("approved_clients");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_approved_clients_, member_approved_clients_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("domain_hints");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_domain_hints_, member_domain_hints_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("email");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_email_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("given_name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_given_name_, member_given_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("id");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("login_hints");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_login_hints_, member_login_hints_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("picture");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_picture_, member_picture_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> IdentityProviderAccount::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
