// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_credential_error_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"code",
"error",
"url",
};


}  // namespace 

IdentityCredentialErrorInit* IdentityCredentialErrorInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  IdentityCredentialErrorInit* dictionary = MakeGarbageCollected<IdentityCredentialErrorInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "IdentityCredentialErrorInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 IdentityCredentialErrorInit::IdentityCredentialErrorInit() {
  
}

 IdentityCredentialErrorInit::IdentityCredentialErrorInit(v8::Isolate* isolate) {
  
}



String IdentityCredentialErrorInit::getCodeOr(const String& fallback_value) const {
  if (!hasCode()) {
  return fallback_value;
}
return member_code_;
}

String IdentityCredentialErrorInit::getCodeOr(String&& fallback_value) const {
  if (!hasCode()) {
  return std::move(fallback_value);
}
return member_code_;
}

void IdentityCredentialErrorInit::setCode(const String& value) {
  member_code_ = value;
has_code_ = true;
}

void IdentityCredentialErrorInit::setCode(String&& value) {
  member_code_ = std::move(value);
has_code_ = true;
}




String IdentityCredentialErrorInit::getErrorOr(const String& fallback_value) const {
  if (!hasError()) {
  return fallback_value;
}
return member_error_;
}

String IdentityCredentialErrorInit::getErrorOr(String&& fallback_value) const {
  if (!hasError()) {
  return std::move(fallback_value);
}
return member_error_;
}

void IdentityCredentialErrorInit::setError(const String& value) {
  member_error_ = value;
has_error_ = true;
}

void IdentityCredentialErrorInit::setError(String&& value) {
  member_error_ = std::move(value);
has_error_ = true;
}




String IdentityCredentialErrorInit::getUrlOr(const String& fallback_value) const {
  if (!hasUrl()) {
  return fallback_value;
}
return member_url_;
}

String IdentityCredentialErrorInit::getUrlOr(String&& fallback_value) const {
  if (!hasUrl()) {
  return std::move(fallback_value);
}
return member_url_;
}

void IdentityCredentialErrorInit::setUrl(const String& value) {
  member_url_ = value;
has_url_ = true;
}

void IdentityCredentialErrorInit::setUrl(String&& value) {
  member_url_ = std::move(value);
has_url_ = true;
}



void IdentityCredentialErrorInit::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void IdentityCredentialErrorInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "IdentityCredentialErrorInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("code");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_code_, member_code_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FedCmErrorAttributeEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("error");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_error_, member_error_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("url");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_url_, member_url_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> IdentityCredentialErrorInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
