// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_GET_ALL_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_GET_ALL_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_cursor_direction.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IDBGetAllOptions : public bindings::InputDictionaryBase {
  
  public:
static IDBGetAllOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IDBGetAllOptions>(isolate);
}
static IDBGetAllOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IDBGetAllOptions(v8::Isolate* isolate);

bool hasCount() const {
  return has_count_;
}
uint32_t count() const {
  DCHECK(hasCount());
return member_count_;
}
uint32_t getCountOr(uint32_t fallback_value) const {
  if (!hasCount()) {
  return fallback_value;
}
return member_count_;
}
void setCount(uint32_t value) {
  member_count_ = value;
has_count_ = true;
}

bool hasDirection() const {
  return true;
}
V8IDBCursorDirection direction() const {
  return member_direction_;
}
void setDirection(V8IDBCursorDirection value) {
  member_direction_ = value;
}
void setDirection(V8IDBCursorDirection::Enum value) {
  member_direction_ = V8IDBCursorDirection(value);
}

bool hasQuery() const {
  return true;
}
const ScriptValue& query() const {
  return member_query_;
}
void setQuery(const ScriptValue& value) {
  member_query_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_count_ = false;

uint32_t member_count_;
V8IDBCursorDirection member_direction_{V8IDBCursorDirection::Enum::kNext};
ScriptValue member_query_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_GET_ALL_OPTIONS_H_
