// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_handwriting_hints_query_result.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"alternatives",
"inputType",
"recognitionType",
"textContext",
};


}  // namespace 

HandwritingHintsQueryResult* HandwritingHintsQueryResult::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  HandwritingHintsQueryResult* dictionary = MakeGarbageCollected<HandwritingHintsQueryResult>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "HandwritingHintsQueryResult";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 HandwritingHintsQueryResult::HandwritingHintsQueryResult() {
  
}

 HandwritingHintsQueryResult::HandwritingHintsQueryResult(v8::Isolate* isolate) {
  
}










Vector<V8HandwritingInputType> HandwritingHintsQueryResult::getInputTypeOr(const Vector<V8HandwritingInputType>& fallback_value) const {
  if (!hasInputType()) {
  return fallback_value;
}
return member_input_type_;
}

Vector<V8HandwritingInputType> HandwritingHintsQueryResult::getInputTypeOr(Vector<V8HandwritingInputType>&& fallback_value) const {
  if (!hasInputType()) {
  return std::move(fallback_value);
}
return member_input_type_;
}

void HandwritingHintsQueryResult::setInputType(const Vector<V8HandwritingInputType>& value) {
  member_input_type_ = value;
has_input_type_ = true;
}

void HandwritingHintsQueryResult::setInputType(Vector<V8HandwritingInputType>&& value) {
  member_input_type_ = std::move(value);
has_input_type_ = true;
}




Vector<V8HandwritingRecognitionType> HandwritingHintsQueryResult::getRecognitionTypeOr(const Vector<V8HandwritingRecognitionType>& fallback_value) const {
  if (!hasRecognitionType()) {
  return fallback_value;
}
return member_recognition_type_;
}

Vector<V8HandwritingRecognitionType> HandwritingHintsQueryResult::getRecognitionTypeOr(Vector<V8HandwritingRecognitionType>&& fallback_value) const {
  if (!hasRecognitionType()) {
  return std::move(fallback_value);
}
return member_recognition_type_;
}

void HandwritingHintsQueryResult::setRecognitionType(const Vector<V8HandwritingRecognitionType>& value) {
  member_recognition_type_ = value;
has_recognition_type_ = true;
}

void HandwritingHintsQueryResult::setRecognitionType(Vector<V8HandwritingRecognitionType>&& value) {
  member_recognition_type_ = std::move(value);
has_recognition_type_ = true;
}










void HandwritingHintsQueryResult::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void HandwritingHintsQueryResult::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void HandwritingHintsQueryResult::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAlternatives()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_alternatives_);
DCHECK(!values[0].IsEmpty());
}
if (hasInputType()) {
  values[1] = ToV8Traits<IDLSequence<V8HandwritingInputType>>::ToV8(script_state, member_input_type_);
DCHECK(!values[1].IsEmpty());
}
if (hasRecognitionType()) {
  values[2] = ToV8Traits<IDLSequence<V8HandwritingRecognitionType>>::ToV8(script_state, member_recognition_type_);
DCHECK(!values[2].IsEmpty());
}
if (hasTextContext()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_text_context_);
DCHECK(!values[3].IsEmpty());
}
}

const void* HandwritingHintsQueryResult::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> HandwritingHintsQueryResult::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void HandwritingHintsQueryResult::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "HandwritingHintsQueryResult";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("alternatives");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_alternatives_, member_alternatives_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("inputType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8HandwritingInputType>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_input_type_, member_input_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("recognitionType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8HandwritingRecognitionType>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_recognition_type_, member_recognition_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("textContext");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_text_context_, member_text_context_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> HandwritingHintsQueryResult::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
