// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_VIEW_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_VIEW_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_aspect.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view_dimension.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUTextureViewDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUTextureViewDescriptor* Create() {
  return MakeGarbageCollected<GPUTextureViewDescriptor>();
}
static GPUTextureViewDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUTextureViewDescriptor>(isolate);
}
static GPUTextureViewDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUTextureViewDescriptor();
explicit  GPUTextureViewDescriptor(v8::Isolate* isolate);

bool hasArrayLayerCount() const {
  return has_array_layer_count_;
}
uint32_t arrayLayerCount() const {
  DCHECK(hasArrayLayerCount());
return member_array_layer_count_;
}
uint32_t getArrayLayerCountOr(uint32_t fallback_value) const {
  if (!hasArrayLayerCount()) {
  return fallback_value;
}
return member_array_layer_count_;
}
void setArrayLayerCount(uint32_t value) {
  member_array_layer_count_ = value;
has_array_layer_count_ = true;
}

bool hasAspect() const {
  return true;
}
V8GPUTextureAspect aspect() const {
  return member_aspect_;
}
void setAspect(V8GPUTextureAspect value) {
  member_aspect_ = value;
}
void setAspect(V8GPUTextureAspect::Enum value) {
  member_aspect_ = V8GPUTextureAspect(value);
}

bool hasBaseArrayLayer() const {
  return true;
}
uint32_t baseArrayLayer() const {
  return member_base_array_layer_;
}
void setBaseArrayLayer(uint32_t value) {
  member_base_array_layer_ = value;
}

bool hasBaseMipLevel() const {
  return true;
}
uint32_t baseMipLevel() const {
  return member_base_mip_level_;
}
void setBaseMipLevel(uint32_t value) {
  member_base_mip_level_ = value;
}

bool hasDimension() const {
  return has_dimension_;
}
V8GPUTextureViewDimension dimension() const {
  DCHECK(hasDimension());
return member_dimension_;
}
V8GPUTextureViewDimension getDimensionOr(V8GPUTextureViewDimension fallback_value) const {
  if (!hasDimension()) {
  return fallback_value;
}
return member_dimension_;
}
void setDimension(V8GPUTextureViewDimension value) {
  member_dimension_ = value;
has_dimension_ = true;
}
void setDimension(V8GPUTextureViewDimension::Enum value) {
  member_dimension_ = V8GPUTextureViewDimension(value);
has_dimension_ = true;
}

bool hasFormat() const {
  return has_format_;
}
V8GPUTextureFormat format() const {
  DCHECK(hasFormat());
return member_format_;
}
V8GPUTextureFormat getFormatOr(V8GPUTextureFormat fallback_value) const {
  if (!hasFormat()) {
  return fallback_value;
}
return member_format_;
}
void setFormat(V8GPUTextureFormat value) {
  member_format_ = value;
has_format_ = true;
}
void setFormat(V8GPUTextureFormat::Enum value) {
  member_format_ = V8GPUTextureFormat(value);
has_format_ = true;
}

bool hasMipLevelCount() const {
  return has_mip_level_count_;
}
uint32_t mipLevelCount() const {
  DCHECK(hasMipLevelCount());
return member_mip_level_count_;
}
uint32_t getMipLevelCountOr(uint32_t fallback_value) const {
  if (!hasMipLevelCount()) {
  return fallback_value;
}
return member_mip_level_count_;
}
void setMipLevelCount(uint32_t value) {
  member_mip_level_count_ = value;
has_mip_level_count_ = true;
}

bool hasSwizzle() const {
  return true;
}
const String& swizzle() const {
  return member_swizzle_;
}
void setSwizzle(const String& value);
void setSwizzle(String&& value);

bool hasUsage() const {
  return true;
}
uint32_t usage() const {
  return member_usage_;
}
void setUsage(uint32_t value) {
  member_usage_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_array_layer_count_ = false;
bool has_dimension_ = false;
bool has_format_ = false;
bool has_mip_level_count_ = false;

uint32_t member_array_layer_count_;
V8GPUTextureAspect member_aspect_{V8GPUTextureAspect::Enum::kAll};
uint32_t member_base_array_layer_{0};
uint32_t member_base_mip_level_{0};
V8GPUTextureViewDimension member_dimension_{static_cast<V8GPUTextureViewDimension::Enum>(0)};
V8GPUTextureFormat member_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
uint32_t member_mip_level_count_;
String member_swizzle_{"rgba"};
uint32_t member_usage_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_VIEW_DESCRIPTOR_H_
