// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_STENCIL_FACE_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_STENCIL_FACE_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compare_function.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_stencil_operation.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUStencilFaceState : public bindings::InputDictionaryBase {
  
  public:
static GPUStencilFaceState* Create() {
  return MakeGarbageCollected<GPUStencilFaceState>();
}
static GPUStencilFaceState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUStencilFaceState>(isolate);
}
static GPUStencilFaceState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUStencilFaceState();
explicit  GPUStencilFaceState(v8::Isolate* isolate);

bool hasCompare() const {
  return true;
}
V8GPUCompareFunction compare() const {
  return member_compare_;
}
void setCompare(V8GPUCompareFunction value) {
  member_compare_ = value;
}
void setCompare(V8GPUCompareFunction::Enum value) {
  member_compare_ = V8GPUCompareFunction(value);
}

bool hasDepthFailOp() const {
  return true;
}
V8GPUStencilOperation depthFailOp() const {
  return member_depth_fail_op_;
}
void setDepthFailOp(V8GPUStencilOperation value) {
  member_depth_fail_op_ = value;
}
void setDepthFailOp(V8GPUStencilOperation::Enum value) {
  member_depth_fail_op_ = V8GPUStencilOperation(value);
}

bool hasFailOp() const {
  return true;
}
V8GPUStencilOperation failOp() const {
  return member_fail_op_;
}
void setFailOp(V8GPUStencilOperation value) {
  member_fail_op_ = value;
}
void setFailOp(V8GPUStencilOperation::Enum value) {
  member_fail_op_ = V8GPUStencilOperation(value);
}

bool hasPassOp() const {
  return true;
}
V8GPUStencilOperation passOp() const {
  return member_pass_op_;
}
void setPassOp(V8GPUStencilOperation value) {
  member_pass_op_ = value;
}
void setPassOp(V8GPUStencilOperation::Enum value) {
  member_pass_op_ = V8GPUStencilOperation(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8GPUCompareFunction member_compare_{V8GPUCompareFunction::Enum::kAlways};
V8GPUStencilOperation member_depth_fail_op_{V8GPUStencilOperation::Enum::kKeep};
V8GPUStencilOperation member_fail_op_{V8GPUStencilOperation::Enum::kKeep};
V8GPUStencilOperation member_pass_op_{V8GPUStencilOperation::Enum::kKeep};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_STENCIL_FACE_STATE_H_
