// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_module_compilation_hint.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_gpuautolayoutmode_gpupipelinelayout.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_pipeline_layout.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"entryPoint",
"layout",
};


}  // namespace 

GPUShaderModuleCompilationHint* GPUShaderModuleCompilationHint::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUShaderModuleCompilationHint* dictionary = MakeGarbageCollected<GPUShaderModuleCompilationHint>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUShaderModuleCompilationHint";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUShaderModuleCompilationHint::GPUShaderModuleCompilationHint() {
  
}

 GPUShaderModuleCompilationHint::GPUShaderModuleCompilationHint(v8::Isolate* isolate) {
  
}



void GPUShaderModuleCompilationHint::setEntryPoint(const String& value) {
  member_entry_point_ = value;
}

void GPUShaderModuleCompilationHint::setEntryPoint(String&& value) {
  member_entry_point_ = std::move(value);
}










void GPUShaderModuleCompilationHint::Trace(Visitor* visitor) const {
  visitor->Trace(member_layout_);
bindings::InputDictionaryBase::Trace(visitor);
}

void GPUShaderModuleCompilationHint::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "GPUShaderModuleCompilationHint";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("entryPoint");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_entry_point_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("layout");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionGPUAutoLayoutModeOrGPUPipelineLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_layout_, member_layout_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUShaderModuleCompilationHint::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
