// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_LAYOUT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_LAYOUT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPURenderPassLayout : public GPUObjectDescriptorBase {
  
  public:
static GPURenderPassLayout* Create() {
  return MakeGarbageCollected<GPURenderPassLayout>();
}
static GPURenderPassLayout* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderPassLayout>(isolate);
}
static GPURenderPassLayout* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderPassLayout();
explicit  GPURenderPassLayout(v8::Isolate* isolate);

bool hasColorFormats() const {
  return true;
}
const Vector<std::optional<V8GPUTextureFormat>>& colorFormats() const {
  return member_color_formats_;
}
void setColorFormats(const Vector<std::optional<V8GPUTextureFormat>>& value);
void setColorFormats(Vector<std::optional<V8GPUTextureFormat>>&& value);

bool hasDepthStencilFormat() const {
  return has_depth_stencil_format_;
}
V8GPUTextureFormat depthStencilFormat() const {
  DCHECK(hasDepthStencilFormat());
return member_depth_stencil_format_;
}
V8GPUTextureFormat getDepthStencilFormatOr(V8GPUTextureFormat fallback_value) const {
  if (!hasDepthStencilFormat()) {
  return fallback_value;
}
return member_depth_stencil_format_;
}
void setDepthStencilFormat(V8GPUTextureFormat value) {
  member_depth_stencil_format_ = value;
has_depth_stencil_format_ = true;
}
void setDepthStencilFormat(V8GPUTextureFormat::Enum value) {
  member_depth_stencil_format_ = V8GPUTextureFormat(value);
has_depth_stencil_format_ = true;
}

bool hasSampleCount() const {
  return true;
}
uint32_t sampleCount() const {
  return member_sample_count_;
}
void setSampleCount(uint32_t value) {
  member_sample_count_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_stencil_format_ = false;

Vector<std::optional<V8GPUTextureFormat>> member_color_formats_;
V8GPUTextureFormat member_depth_stencil_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
uint32_t member_sample_count_{1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_LAYOUT_H_
