// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_encoder.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_color_dict.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_index_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_doublesequence_gpucolordict.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_bind_group.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_query_set.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_bundle.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_pass_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_pipeline.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8GPURenderPassEncoder::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope());
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8GPURenderPassEncoder::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8GPURenderPassEncoder::InstallInterfaceTemplate,
    nullptr,
    "GPURenderPassEncoder",
    nullptr,
    V8GPURenderPassEncoder::kThisTag,
    V8GPURenderPassEncoder::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& GPURenderPassEncoder::wrapper_type_info_ =
    V8GPURenderPassEncoder::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, GPURenderPassEncoder>::value,
    "GPURenderPassEncoder inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_gpu_render_pass_encoder {


void LabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_label_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.label.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->label();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_label_Setter");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.label.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLabel(arg1_value);

}

void BeginOcclusionQueryOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_query_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_query_index = v8_arg1_query_index;
blink_receiver->beginOcclusionQuery(arg1_query_index);
}

void BeginOcclusionQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_beginOcclusionQuery");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.beginOcclusionQuery");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->beginOcclusionQuery(arg1_query_index);

}

void DrawOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_vertex, uint32_t v8_arg4_first_instance, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_vertex = v8_arg3_first_vertex;
auto&& arg4_first_instance = v8_arg4_first_instance;
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_vertex, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_vertex = v8_arg3_first_vertex;
auto&& arg4_first_instance{0};
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, uint32_t v8_arg2_instance_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_vertex{0};
auto&& arg4_first_instance{0};
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count{1};
auto&& arg3_first_vertex{0};
auto&& arg4_first_instance{0};
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_draw");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.draw");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_vertex_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_instance_count{1};
if (!info[1]->IsUndefined()) {
  arg2_instance_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_first_vertex{0};
if (!info[2]->IsUndefined()) {
  arg3_first_vertex = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_first_instance{0};
if (!info[3]->IsUndefined()) {
  arg4_first_instance = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);

}

void DrawIndexedOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_index, int32_t v8_arg4_base_vertex, uint32_t v8_arg5_first_instance, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index = v8_arg3_first_index;
auto&& arg4_base_vertex = v8_arg4_base_vertex;
auto&& arg5_first_instance = v8_arg5_first_instance;
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_index, int32_t v8_arg4_base_vertex, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index = v8_arg3_first_index;
auto&& arg4_base_vertex = v8_arg4_base_vertex;
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index = v8_arg3_first_index;
auto&& arg4_base_vertex{0};
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index{0};
auto&& arg4_base_vertex{0};
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count{1};
auto&& arg3_first_index{0};
auto&& arg4_base_vertex{0};
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_drawIndexed");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.drawIndexed");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_instance_count{1};
if (!info[1]->IsUndefined()) {
  arg2_instance_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_first_index{0};
if (!info[2]->IsUndefined()) {
  arg3_first_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_base_vertex{0};
if (!info[3]->IsUndefined()) {
  arg4_base_vertex = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_first_instance{0};
if (!info[4]->IsUndefined()) {
  arg5_first_instance = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);

}

void DrawIndexedIndirectOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
blink_receiver->drawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset);
}

void DrawIndexedIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_drawIndexedIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.drawIndexedIndirect");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset);

}

void DrawIndirectOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
blink_receiver->drawIndirect(arg1_indirect_buffer, arg2_indirect_offset);
}

void DrawIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_drawIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.drawIndirect");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawIndirect(arg1_indirect_buffer, arg2_indirect_offset);

}

void EndOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->end();
}

void EndOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_end");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.end");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->end();

}

void EndOcclusionQueryOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->endOcclusionQuery();
}

void EndOcclusionQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_endOcclusionQuery");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.endOcclusionQuery");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->endOcclusionQuery();

}

void ExecuteBundlesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_executeBundles");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.executeBundles");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_bundles = NativeValueTraits<IDLSequence<GPURenderBundle>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->executeBundles(std::move(arg1_bundles));

}

void InsertDebugMarkerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_insertDebugMarker");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.insertDebugMarker");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_marker_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->insertDebugMarker(arg1_marker_label);

}

void MultiDrawIndexedIndirectOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, uint32_t v8_arg3_max_draw_count, v8::Local<v8::Value> v8_arg4_draw_count_buffer, uint64_t v8_arg5_draw_count_buffer_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
auto&& arg3_max_draw_count = v8_arg3_max_draw_count;
auto&& arg4_draw_count_buffer = NativeValueTraits<IDLOptional<GPUBuffer>>::ArgumentValue(isolate, 3, v8_arg4_draw_count_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_draw_count_buffer_offset = v8_arg5_draw_count_buffer_offset;
blink_receiver->multiDrawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, arg4_draw_count_buffer, arg5_draw_count_buffer_offset, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void MultiDrawIndexedIndirectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, uint32_t v8_arg3_max_draw_count, v8::Local<v8::Value> v8_arg4_draw_count_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
auto&& arg3_max_draw_count = v8_arg3_max_draw_count;
auto&& arg4_draw_count_buffer = NativeValueTraits<IDLOptional<GPUBuffer>>::ArgumentValue(isolate, 3, v8_arg4_draw_count_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_draw_count_buffer_offset{0};
blink_receiver->multiDrawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, arg4_draw_count_buffer, arg5_draw_count_buffer_offset, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void MultiDrawIndexedIndirectOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, uint32_t v8_arg3_max_draw_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
auto&& arg3_max_draw_count = v8_arg3_max_draw_count;
blink_receiver->multiDrawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void MultiDrawIndexedIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_multiDrawIndexedIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.multiDrawIndexedIndirect");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_max_draw_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->multiDrawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, exception_state);
break;
}
auto&& arg4_draw_count_buffer = NativeValueTraits<IDLOptional<GPUBuffer>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_draw_count_buffer_offset{0};
if (!info[4]->IsUndefined()) {
  arg5_draw_count_buffer_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->multiDrawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, arg4_draw_count_buffer, arg5_draw_count_buffer_offset, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void MultiDrawIndirectOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, uint32_t v8_arg3_max_draw_count, v8::Local<v8::Value> v8_arg4_draw_count_buffer, uint64_t v8_arg5_draw_count_buffer_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
auto&& arg3_max_draw_count = v8_arg3_max_draw_count;
auto&& arg4_draw_count_buffer = NativeValueTraits<IDLOptional<GPUBuffer>>::ArgumentValue(isolate, 3, v8_arg4_draw_count_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_draw_count_buffer_offset = v8_arg5_draw_count_buffer_offset;
blink_receiver->multiDrawIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, arg4_draw_count_buffer, arg5_draw_count_buffer_offset, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void MultiDrawIndirectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, uint32_t v8_arg3_max_draw_count, v8::Local<v8::Value> v8_arg4_draw_count_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
auto&& arg3_max_draw_count = v8_arg3_max_draw_count;
auto&& arg4_draw_count_buffer = NativeValueTraits<IDLOptional<GPUBuffer>>::ArgumentValue(isolate, 3, v8_arg4_draw_count_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_draw_count_buffer_offset{0};
blink_receiver->multiDrawIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, arg4_draw_count_buffer, arg5_draw_count_buffer_offset, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void MultiDrawIndirectOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, uint32_t v8_arg3_max_draw_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
auto&& arg3_max_draw_count = v8_arg3_max_draw_count;
blink_receiver->multiDrawIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void MultiDrawIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_multiDrawIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.multiDrawIndirect");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_max_draw_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->multiDrawIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, exception_state);
break;
}
auto&& arg4_draw_count_buffer = NativeValueTraits<IDLOptional<GPUBuffer>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_draw_count_buffer_offset{0};
if (!info[4]->IsUndefined()) {
  arg5_draw_count_buffer_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->multiDrawIndirect(arg1_indirect_buffer, arg2_indirect_offset, arg3_max_draw_count, arg4_draw_count_buffer, arg5_draw_count_buffer_offset, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void PopDebugGroupOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();
}

void PopDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_popDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.popDebugGroup");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();

}

void PushDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_pushDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.pushDebugGroup");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_group_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pushDebugGroup(arg1_group_label);

}

void SetBindGroupOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::Local<v8::Value> v8_arg3_dynamic_offsets, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets = NativeValueTraits<IDLSequence<IDLUnsignedLongEnforceRange>>::ArgumentValue(isolate, 2, v8_arg3_dynamic_offsets, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets);
}

void SetBindGroupOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group);
}

void SetBindGroupOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::Local<v8::Value> v8_arg3_dynamic_offsets_data, uint64_t v8_arg4_dynamic_offsets_data_start, uint32_t v8_arg5_dynamic_offsets_data_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, v8_arg3_dynamic_offsets_data, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dynamic_offsets_data_start = v8_arg4_dynamic_offsets_data_start;
auto&& arg5_dynamic_offsets_data_length = v8_arg5_dynamic_offsets_data_length;
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets_data, arg4_dynamic_offsets_data_start, arg5_dynamic_offsets_data_length, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void SetBindGroupOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->setBindGroup(arg1_index, arg2_bind_group);
break;
}
auto&& arg3_dynamic_offsets = NativeValueTraits<IDLSequence<IDLUnsignedLongEnforceRange>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, std::move(arg3_dynamic_offsets));
} while (false);

}

void SetBindGroupOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dynamic_offsets_data_start = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_dynamic_offsets_data_length = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets_data, arg4_dynamic_offsets_data_start, arg5_dynamic_offsets_data_length, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetBindGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setBindGroup");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setBindGroup");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return SetBindGroupOperationOverload2(info);
}
if (arg_count == 3) {
  return SetBindGroupOperationOverload1(info);
}
if (arg_count == 2) {
  return SetBindGroupOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetBlendConstantOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setBlendConstant");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setBlendConstant");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_color = NativeValueTraits<V8UnionDoubleSequenceOrGPUColorDict>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBlendConstant(arg1_color, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetImmediatesOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_range_offset = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<DOMArrayBufferBase>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_data_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_data_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, exception_state);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, arg4_size, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetImmediatesOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_range_offset = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_data_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_data_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, exception_state);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, arg4_size, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetImmediatesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setImmediates");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setImmediates");


const int arg_count = std::min(info.Length(), 4);
do {  // Dummy loop for use of 'break'.
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (arg_count == 4) {
  if (info[1]->IsObject()) {
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return SetImmediatesOperationOverload1(info);
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBufferView()) {
  return SetImmediatesOperationOverload2(info);
}
}
}
break;
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (arg_count == 3) {
  if (info[1]->IsObject()) {
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return SetImmediatesOperationOverload1(info);
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBufferView()) {
  return SetImmediatesOperationOverload2(info);
}
}
}
break;
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (arg_count == 2) {
  if (info[1]->IsObject()) {
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return SetImmediatesOperationOverload1(info);
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBufferView()) {
  return SetImmediatesOperationOverload2(info);
}
}
}
break;
}
}
} while (false);

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetIndexBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setIndexBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setIndexBuffer");



if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_format = NativeValueTraits<V8GPUIndexFormat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setIndexBuffer(arg1_buffer, arg2_format, arg3_offset);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setIndexBuffer(arg1_buffer, arg2_format, arg3_offset, arg4_size);
} while (false);

}

void SetPipelineOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_pipeline, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pipeline = NativeValueTraits<GPURenderPipeline>::ArgumentValue(isolate, 0, v8_arg1_pipeline, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setPipeline(arg1_pipeline);
}

void SetPipelineOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setPipeline");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setPipeline");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pipeline = NativeValueTraits<GPURenderPipeline>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setPipeline(arg1_pipeline);

}

void SetScissorRectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_x, uint32_t v8_arg2_y, uint32_t v8_arg3_width, uint32_t v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->setScissorRect(arg1_x, arg2_y, arg3_width, arg4_height);
}

void SetScissorRectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setScissorRect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setScissorRect");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setScissorRect(arg1_x, arg2_y, arg3_width, arg4_height);

}

void SetStencilReferenceOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_reference, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_reference = v8_arg1_reference;
blink_receiver->setStencilReference(arg1_reference);
}

void SetStencilReferenceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setStencilReference");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setStencilReference");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_reference = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setStencilReference(arg1_reference);

}

void SetVertexBufferOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_slot, v8::Local<v8::Value> v8_arg2_buffer, uint64_t v8_arg3_offset, uint64_t v8_arg4_size, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_slot = v8_arg1_slot;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_offset = v8_arg3_offset;
auto&& arg4_size = v8_arg4_size;
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset, arg4_size);
}

void SetVertexBufferOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_slot, v8::Local<v8::Value> v8_arg2_buffer, uint64_t v8_arg3_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_slot = v8_arg1_slot;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_offset = v8_arg3_offset;
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset);
}

void SetVertexBufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_slot, v8::Local<v8::Value> v8_arg2_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_slot = v8_arg1_slot;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_offset{0};
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset);
}

void SetVertexBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setVertexBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setVertexBuffer");



if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_slot = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset, arg4_size);
} while (false);

}

void SetViewportOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, float v8_arg1_x, float v8_arg2_y, float v8_arg3_width, float v8_arg4_height, float v8_arg5_min_depth, float v8_arg6_max_depth, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
auto&& arg5_min_depth = v8_arg5_min_depth;
auto&& arg6_max_depth = v8_arg6_max_depth;
blink_receiver->setViewport(arg1_x, arg2_y, arg3_width, arg4_height, arg5_min_depth, arg6_max_depth);
}

void SetViewportOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_setViewport");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.setViewport");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_min_depth = NativeValueTraits<IDLFloat>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_max_depth = NativeValueTraits<IDLFloat>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setViewport(arg1_x, arg2_y, arg3_width, arg4_height, arg5_min_depth, arg6_max_depth);

}

void WriteTimestampOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_query_set, uint32_t v8_arg2_query_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, v8_arg1_query_set, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query_index = v8_arg2_query_index;
blink_receiver->writeTimestamp(arg1_query_set, arg2_query_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void WriteTimestampOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderPassEncoder_writeTimestamp");
BLINK_BINDINGS_TRACE_EVENT("GPURenderPassEncoder.writeTimestamp");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderPassEncoder* blink_receiver = V8GPURenderPassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->writeTimestamp(arg1_query_set, arg2_query_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_gpu_render_pass_encoder

using namespace v8_gpu_render_pass_encoder;

}  // namespace 

void V8GPURenderPassEncoder::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8GPURenderPassEncoder::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8GPURenderPassEncoder::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"label", LabelAttributeGetCallback, LabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderPassEncoder", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"executeBundles", ExecuteBundlesOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"insertDebugMarker", InsertDebugMarkerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pushDebugGroup", PushDebugGroupOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setBlendConstant", SetBlendConstantOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setIndexBuffer", SetIndexBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderPassEncoder", kOperationTable);
}


{
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"beginOcclusionQuery", BeginOcclusionQueryOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"draw", DrawOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawIndexed", DrawIndexedOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawIndexedIndirect", DrawIndexedIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawIndirect", DrawIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"end", EndOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"endOcclusionQuery", EndOcclusionQueryOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setBindGroup", SetBindGroupOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setPipeline", SetPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setScissorRect", SetScissorRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setStencilReference", SetStencilReferenceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setVertexBuffer", SetVertexBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setViewport", SetViewportOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"writeTimestamp", WriteTimestampOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = BeginOcclusionQueryOperationNoAllocDirectCallArg1;
std::ignore = DrawOperationNoAllocDirectCallArg4;
std::ignore = DrawOperationNoAllocDirectCallArg3;
std::ignore = DrawOperationNoAllocDirectCallArg2;
std::ignore = DrawOperationNoAllocDirectCallArg1;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg5;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg4;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg3;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg2;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg1;
std::ignore = DrawIndexedIndirectOperationNoAllocDirectCallArg2;
std::ignore = DrawIndirectOperationNoAllocDirectCallArg2;
std::ignore = EndOperationNoAllocDirectCallArg0;
std::ignore = EndOcclusionQueryOperationNoAllocDirectCallArg0;
std::ignore = PopDebugGroupOperationNoAllocDirectCallArg0;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload1Arg3;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload1Arg2;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload2Arg5;
std::ignore = SetPipelineOperationNoAllocDirectCallArg1;
std::ignore = SetScissorRectOperationNoAllocDirectCallArg4;
std::ignore = SetStencilReferenceOperationNoAllocDirectCallArg1;
std::ignore = SetVertexBufferOperationNoAllocDirectCallArg4;
std::ignore = SetVertexBufferOperationNoAllocDirectCallArg3;
std::ignore = SetVertexBufferOperationNoAllocDirectCallArg2;
std::ignore = SetViewportOperationNoAllocDirectCallArg6;
std::ignore = WriteTimestampOperationNoAllocDirectCallArg2;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfBeginOcclusionQuery[] = {
v8::CFunctionBuilder().Fn(BeginOcclusionQueryOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDraw[] = {
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawIndexed[] = {
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg5).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawIndexedIndirect[] = {
v8::CFunctionBuilder().Fn(DrawIndexedIndirectOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawIndirect[] = {
v8::CFunctionBuilder().Fn(DrawIndirectOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEnd[] = {
v8::CFunctionBuilder().Fn(EndOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEndOcclusionQuery[] = {
v8::CFunctionBuilder().Fn(EndOcclusionQueryOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfPopDebugGroup[] = {
v8::CFunctionBuilder().Fn(PopDebugGroupOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetBindGroup[] = {
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload1Arg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload1Arg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload2Arg5).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetPipeline[] = {
v8::CFunctionBuilder().Fn(SetPipelineOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetScissorRect[] = {
v8::CFunctionBuilder().Fn(SetScissorRectOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetStencilReference[] = {
v8::CFunctionBuilder().Fn(SetStencilReferenceOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetVertexBuffer[] = {
v8::CFunctionBuilder().Fn(SetVertexBufferOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetVertexBufferOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetVertexBufferOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetViewport[] = {
v8::CFunctionBuilder().Fn(SetViewportOperationNoAllocDirectCallArg6).Arg<1, v8::CTypeInfo::Flags::kIsRestrictedBit>().Arg<2, v8::CTypeInfo::Flags::kIsRestrictedBit>().Arg<3, v8::CTypeInfo::Flags::kIsRestrictedBit>().Arg<4, v8::CTypeInfo::Flags::kIsRestrictedBit>().Arg<5, v8::CTypeInfo::Flags::kIsRestrictedBit>().Arg<6, v8::CTypeInfo::Flags::kIsRestrictedBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfWriteTimestamp[] = {
v8::CFunctionBuilder().Fn(WriteTimestampOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"beginOcclusionQuery", BeginOcclusionQueryOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBeginOcclusionQuery, std::size(kNoAllocDirectCallOverloadsOfBeginOcclusionQuery)}, 
{{"draw", DrawOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDraw, std::size(kNoAllocDirectCallOverloadsOfDraw)}, 
{{"drawIndexed", DrawIndexedOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawIndexed, std::size(kNoAllocDirectCallOverloadsOfDrawIndexed)}, 
{{"drawIndexedIndirect", DrawIndexedIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawIndexedIndirect, std::size(kNoAllocDirectCallOverloadsOfDrawIndexedIndirect)}, 
{{"drawIndirect", DrawIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawIndirect, std::size(kNoAllocDirectCallOverloadsOfDrawIndirect)}, 
{{"end", EndOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEnd, std::size(kNoAllocDirectCallOverloadsOfEnd)}, 
{{"endOcclusionQuery", EndOcclusionQueryOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEndOcclusionQuery, std::size(kNoAllocDirectCallOverloadsOfEndOcclusionQuery)}, 
{{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfPopDebugGroup, std::size(kNoAllocDirectCallOverloadsOfPopDebugGroup)}, 
{{"setBindGroup", SetBindGroupOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetBindGroup, std::size(kNoAllocDirectCallOverloadsOfSetBindGroup)}, 
{{"setPipeline", SetPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetPipeline, std::size(kNoAllocDirectCallOverloadsOfSetPipeline)}, 
{{"setScissorRect", SetScissorRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetScissorRect, std::size(kNoAllocDirectCallOverloadsOfSetScissorRect)}, 
{{"setStencilReference", SetStencilReferenceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetStencilReference, std::size(kNoAllocDirectCallOverloadsOfSetStencilReference)}, 
{{"setVertexBuffer", SetVertexBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetVertexBuffer, std::size(kNoAllocDirectCallOverloadsOfSetVertexBuffer)}, 
{{"setViewport", SetViewportOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetViewport, std::size(kNoAllocDirectCallOverloadsOfSetViewport)}, 
{{"writeTimestamp", WriteTimestampOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfWriteTimestamp, std::size(kNoAllocDirectCallOverloadsOfWriteTimestamp)}, 
};
#endif  // defined(ARCH_CPU_X86)
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderPassEncoder", kOperationTable);
}


}

void V8GPURenderPassEncoder::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"setImmediates", SetImmediatesOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderPassEncoder", kOperationTable);
}

if (RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled()) {
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"multiDrawIndexedIndirect", MultiDrawIndexedIndirectOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"multiDrawIndirect", MultiDrawIndirectOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = MultiDrawIndexedIndirectOperationNoAllocDirectCallArg5;
std::ignore = MultiDrawIndexedIndirectOperationNoAllocDirectCallArg4;
std::ignore = MultiDrawIndexedIndirectOperationNoAllocDirectCallArg3;
std::ignore = MultiDrawIndirectOperationNoAllocDirectCallArg5;
std::ignore = MultiDrawIndirectOperationNoAllocDirectCallArg4;
std::ignore = MultiDrawIndirectOperationNoAllocDirectCallArg3;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawIndexedIndirect[] = {
v8::CFunctionBuilder().Fn(MultiDrawIndexedIndirectOperationNoAllocDirectCallArg5).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(MultiDrawIndexedIndirectOperationNoAllocDirectCallArg4).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(MultiDrawIndexedIndirectOperationNoAllocDirectCallArg3).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawIndirect[] = {
v8::CFunctionBuilder().Fn(MultiDrawIndirectOperationNoAllocDirectCallArg5).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(MultiDrawIndirectOperationNoAllocDirectCallArg4).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(MultiDrawIndirectOperationNoAllocDirectCallArg3).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"multiDrawIndexedIndirect", MultiDrawIndexedIndirectOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawIndexedIndirect, std::size(kNoAllocDirectCallOverloadsOfMultiDrawIndexedIndirect)}, 
{{"multiDrawIndirect", MultiDrawIndirectOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawIndirect, std::size(kNoAllocDirectCallOverloadsOfMultiDrawIndirect)}, 
};
#endif  // defined(ARCH_CPU_X86)
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderPassEncoder", kOperationTable);
}

}



}  // namespace blink
