// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_descriptor.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_color_attachment.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_depth_stencil_attachment.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_timestamp_writes.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_query_set.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"colorAttachments",
"depthStencilAttachment",
"maxDrawCount",
"occlusionQuerySet",
"timestampWrites",
};


}  // namespace 

GPURenderPassDescriptor* GPURenderPassDescriptor::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPURenderPassDescriptor* dictionary = MakeGarbageCollected<GPURenderPassDescriptor>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPURenderPassDescriptor";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPURenderPassDescriptor::GPURenderPassDescriptor() {
  
}

 GPURenderPassDescriptor::GPURenderPassDescriptor(v8::Isolate* isolate) : GPUObjectDescriptorBase(isolate) {
  
}



void GPURenderPassDescriptor::setColorAttachments(const HeapVector<Member<GPURenderPassColorAttachment>>& value) {
  member_color_attachments_ = value;
}

void GPURenderPassDescriptor::setColorAttachments(HeapVector<Member<GPURenderPassColorAttachment>>&& value) {
  member_color_attachments_ = std::move(value);
}































void GPURenderPassDescriptor::Trace(Visitor* visitor) const {
  visitor->Trace(member_color_attachments_);
visitor->Trace(member_depth_stencil_attachment_);
visitor->Trace(member_occlusion_query_set_);
visitor->Trace(member_timestamp_writes_);
GPUObjectDescriptorBase::Trace(visitor);
}

void GPURenderPassDescriptor::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
GPUObjectDescriptorBase::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "GPURenderPassDescriptor";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("colorAttachments");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLNullable<GPURenderPassColorAttachment>>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_color_attachments_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthStencilAttachment");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<GPURenderPassDepthStencilAttachment, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_depth_stencil_attachment_, member_depth_stencil_attachment_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxDrawCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_max_draw_count_, member_max_draw_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("occlusionQuerySet");
if (!bindings::GetDictionaryMemberFromV8Object<GPUQuerySet, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_occlusion_query_set_, member_occlusion_query_set_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timestampWrites");
if (!bindings::GetDictionaryMemberFromV8Object<GPURenderPassTimestampWrites, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_timestamp_writes_, member_timestamp_writes_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPURenderPassDescriptor::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
