// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_depth_stencil_attachment.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_gputexture_gputextureview.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture_view.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"depthClearValue",
"depthLoadOp",
"depthReadOnly",
"depthStoreOp",
"stencilClearValue",
"stencilLoadOp",
"stencilReadOnly",
"stencilStoreOp",
"view",
};


}  // namespace 

GPURenderPassDepthStencilAttachment* GPURenderPassDepthStencilAttachment::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPURenderPassDepthStencilAttachment* dictionary = MakeGarbageCollected<GPURenderPassDepthStencilAttachment>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPURenderPassDepthStencilAttachment";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPURenderPassDepthStencilAttachment::GPURenderPassDepthStencilAttachment() {
  
}

 GPURenderPassDepthStencilAttachment::GPURenderPassDepthStencilAttachment(v8::Isolate* isolate) {
  
}

























































void GPURenderPassDepthStencilAttachment::Trace(Visitor* visitor) const {
  visitor->Trace(member_view_);
bindings::InputDictionaryBase::Trace(visitor);
}

void GPURenderPassDepthStencilAttachment::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "GPURenderPassDepthStencilAttachment";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("depthClearValue");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_depth_clear_value_, member_depth_clear_value_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthLoadOp");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPULoadOp, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_depth_load_op_, member_depth_load_op_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthReadOnly");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_depth_read_only_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthStoreOp");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUStoreOp, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_depth_store_op_, member_depth_store_op_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stencilClearValue");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_stencil_clear_value_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stencilLoadOp");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPULoadOp, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_stencil_load_op_, member_stencil_load_op_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stencilReadOnly");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_stencil_read_only_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stencilStoreOp");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUStoreOp, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_stencil_store_op_, member_stencil_store_op_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("view");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionGPUTextureOrGPUTextureView, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_view_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPURenderPassDepthStencilAttachment::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
