// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_COLOR_ATTACHMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_COLOR_ATTACHMENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_load_op.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_store_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUColorDict;
class GPUTexture;
class GPUTextureView;
class V8UnionDoubleSequenceOrGPUColorDict;
class V8UnionGPUTextureOrGPUTextureView;

class MODULES_EXPORT GPURenderPassColorAttachment : public bindings::InputDictionaryBase {
  
  public:
static GPURenderPassColorAttachment* Create() {
  return MakeGarbageCollected<GPURenderPassColorAttachment>();
}
static GPURenderPassColorAttachment* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderPassColorAttachment>(isolate);
}
static GPURenderPassColorAttachment* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderPassColorAttachment();
explicit  GPURenderPassColorAttachment(v8::Isolate* isolate);

bool hasClearValue() const {
  return has_clear_value_;
}
V8UnionDoubleSequenceOrGPUColorDict* clearValue() const {
  DCHECK(hasClearValue());
return member_clear_value_.Get();
}
V8UnionDoubleSequenceOrGPUColorDict* getClearValueOr(V8UnionDoubleSequenceOrGPUColorDict* fallback_value) const {
  if (!hasClearValue()) {
  return fallback_value;
}
return member_clear_value_.Get();
}
void setClearValue(V8UnionDoubleSequenceOrGPUColorDict* value) {
  member_clear_value_ = value;
has_clear_value_ = true;
DCHECK(member_clear_value_);
}

bool hasDepthSlice() const {
  return has_depth_slice_;
}
uint32_t depthSlice() const {
  DCHECK(hasDepthSlice());
return member_depth_slice_;
}
uint32_t getDepthSliceOr(uint32_t fallback_value) const {
  if (!hasDepthSlice()) {
  return fallback_value;
}
return member_depth_slice_;
}
void setDepthSlice(uint32_t value) {
  member_depth_slice_ = value;
has_depth_slice_ = true;
}

bool hasLoadOp() const {
  return true;
}
V8GPULoadOp loadOp() const {
  return member_load_op_;
}
void setLoadOp(V8GPULoadOp value) {
  member_load_op_ = value;
}
void setLoadOp(V8GPULoadOp::Enum value) {
  member_load_op_ = V8GPULoadOp(value);
}

bool hasResolveTarget() const {
  return has_resolve_target_;
}
V8UnionGPUTextureOrGPUTextureView* resolveTarget() const {
  DCHECK(hasResolveTarget());
return member_resolve_target_.Get();
}
V8UnionGPUTextureOrGPUTextureView* getResolveTargetOr(V8UnionGPUTextureOrGPUTextureView* fallback_value) const {
  if (!hasResolveTarget()) {
  return fallback_value;
}
return member_resolve_target_.Get();
}
void setResolveTarget(V8UnionGPUTextureOrGPUTextureView* value) {
  member_resolve_target_ = value;
has_resolve_target_ = true;
DCHECK(member_resolve_target_);
}

bool hasStoreOp() const {
  return true;
}
V8GPUStoreOp storeOp() const {
  return member_store_op_;
}
void setStoreOp(V8GPUStoreOp value) {
  member_store_op_ = value;
}
void setStoreOp(V8GPUStoreOp::Enum value) {
  member_store_op_ = V8GPUStoreOp(value);
}

bool hasView() const {
  return true;
}
V8UnionGPUTextureOrGPUTextureView* view() const {
  return member_view_.Get();
}
void setView(V8UnionGPUTextureOrGPUTextureView* value) {
  member_view_ = value;
DCHECK(member_view_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_clear_value_ = false;
bool has_depth_slice_ = false;
bool has_resolve_target_ = false;

Member<V8UnionDoubleSequenceOrGPUColorDict> member_clear_value_;
uint32_t member_depth_slice_;
V8GPULoadOp member_load_op_{static_cast<V8GPULoadOp::Enum>(0)};
Member<V8UnionGPUTextureOrGPUTextureView> member_resolve_target_;
V8GPUStoreOp member_store_op_{static_cast<V8GPUStoreOp::Enum>(0)};
Member<V8UnionGPUTextureOrGPUTextureView> member_view_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_COLOR_ATTACHMENT_H_
