// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_QUERY_SET_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_QUERY_SET_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUQuerySetDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUQuerySetDescriptor* Create() {
  return MakeGarbageCollected<GPUQuerySetDescriptor>();
}
static GPUQuerySetDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUQuerySetDescriptor>(isolate);
}
static GPUQuerySetDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUQuerySetDescriptor();
explicit  GPUQuerySetDescriptor(v8::Isolate* isolate);

bool hasCount() const {
  return true;
}
uint32_t count() const {
  return member_count_;
}
void setCount(uint32_t value) {
  member_count_ = value;
}

bool hasType() const {
  return true;
}
V8GPUQueryType type() const {
  return member_type_;
}
void setType(V8GPUQueryType value) {
  member_type_ = value;
}
void setType(V8GPUQueryType::Enum value) {
  member_type_ = V8GPUQueryType(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_count_;
V8GPUQueryType member_type_{static_cast<V8GPUQueryType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_QUERY_SET_DESCRIPTOR_H_
