// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_PIPELINE_LAYOUT_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_PIPELINE_LAYOUT_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBindGroupLayout;

class MODULES_EXPORT GPUPipelineLayoutDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUPipelineLayoutDescriptor* Create() {
  return MakeGarbageCollected<GPUPipelineLayoutDescriptor>();
}
static GPUPipelineLayoutDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUPipelineLayoutDescriptor>(isolate);
}
static GPUPipelineLayoutDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUPipelineLayoutDescriptor();
explicit  GPUPipelineLayoutDescriptor(v8::Isolate* isolate);

bool hasBindGroupLayouts() const {
  return true;
}
const HeapVector<Member<GPUBindGroupLayout>>& bindGroupLayouts() const {
  return member_bind_group_layouts_;
}
void setBindGroupLayouts(const HeapVector<Member<GPUBindGroupLayout>>& value);
void setBindGroupLayouts(HeapVector<Member<GPUBindGroupLayout>>&& value);

bool hasImmediateSize() const {
  return true;
}
uint32_t immediateSize() const {
  return member_immediate_size_;
}
void setImmediateSize(uint32_t value) {
  member_immediate_size_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<GPUBindGroupLayout>> member_bind_group_layouts_;
uint32_t member_immediate_size_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_PIPELINE_LAYOUT_DESCRIPTOR_H_
