// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_MULTISAMPLE_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_MULTISAMPLE_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUMultisampleState : public bindings::InputDictionaryBase {
  
  public:
static GPUMultisampleState* Create() {
  return MakeGarbageCollected<GPUMultisampleState>();
}
static GPUMultisampleState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUMultisampleState>(isolate);
}
static GPUMultisampleState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUMultisampleState();
explicit  GPUMultisampleState(v8::Isolate* isolate);

bool hasAlphaToCoverageEnabled() const {
  return true;
}
bool alphaToCoverageEnabled() const {
  return member_alpha_to_coverage_enabled_;
}
void setAlphaToCoverageEnabled(bool value) {
  member_alpha_to_coverage_enabled_ = value;
}

bool hasCount() const {
  return true;
}
uint32_t count() const {
  return member_count_;
}
void setCount(uint32_t value) {
  member_count_ = value;
}

bool hasMask() const {
  return true;
}
uint32_t mask() const {
  return member_mask_;
}
void setMask(uint32_t value) {
  member_mask_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_alpha_to_coverage_enabled_{false};
uint32_t member_count_{1};
uint32_t member_mask_{0xFFFFFFFF};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_MULTISAMPLE_STATE_H_
