// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device_descriptor.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_undefined_unsignedlonglongenforcerange.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_queue_descriptor.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"defaultQueue",
"requiredFeatures",
"requiredLimits",
};


}  // namespace 

GPUDeviceDescriptor* GPUDeviceDescriptor::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUDeviceDescriptor* dictionary = MakeGarbageCollected<GPUDeviceDescriptor>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUDeviceDescriptor";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUDeviceDescriptor::GPUDeviceDescriptor() : member_default_queue_(GPUQueueDescriptor::Create()) {
  
}

 GPUDeviceDescriptor::GPUDeviceDescriptor(v8::Isolate* isolate) : GPUObjectDescriptorBase(isolate), member_default_queue_(GPUQueueDescriptor::Create()) {
  
}








void GPUDeviceDescriptor::setRequiredFeatures(const Vector<V8GPUFeatureName>& value) {
  member_required_features_ = value;
}

void GPUDeviceDescriptor::setRequiredFeatures(Vector<V8GPUFeatureName>&& value) {
  member_required_features_ = std::move(value);
}




HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>> GPUDeviceDescriptor::getRequiredLimitsOr(const HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>& fallback_value) const {
  if (!hasRequiredLimits()) {
  return fallback_value;
}
return member_required_limits_;
}

HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>> GPUDeviceDescriptor::getRequiredLimitsOr(HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>&& fallback_value) const {
  if (!hasRequiredLimits()) {
  return std::move(fallback_value);
}
return member_required_limits_;
}

void GPUDeviceDescriptor::setRequiredLimits(const HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>& value) {
  member_required_limits_ = value;
has_required_limits_ = true;
}

void GPUDeviceDescriptor::setRequiredLimits(HeapVector<std::pair<String, Member<V8UnionUndefinedOrUnsignedLongLongEnforceRange>>>&& value) {
  member_required_limits_ = std::move(value);
has_required_limits_ = true;
}



void GPUDeviceDescriptor::Trace(Visitor* visitor) const {
  visitor->Trace(member_default_queue_);
visitor->Trace(member_required_limits_);
GPUObjectDescriptorBase::Trace(visitor);
}

void GPUDeviceDescriptor::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
GPUObjectDescriptorBase::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "GPUDeviceDescriptor";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("defaultQueue");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<GPUQueueDescriptor, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_default_queue_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requiredFeatures");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8GPUFeatureName>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_required_features_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requiredLimits");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, V8UnionUndefinedOrUnsignedLongLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_required_limits_, member_required_limits_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUDeviceDescriptor::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
