// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_adapter_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group_layout_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_encoder_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pipeline_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device_lost_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_error_filter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_external_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_external_texture_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_layout_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_queue.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle_encoder_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_module.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_module_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_features.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_descriptor.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_adapter_info.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_bind_group.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_bind_group_layout.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_command_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_compute_pipeline.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_device.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_device_lost_info.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_error.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_external_texture.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_pipeline_layout.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_query_set.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_queue.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_bundle_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_pipeline.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_sampler.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_shader_module.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_supported_features.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_supported_limits.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8GPUDevice::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope());
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8GPUDevice::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8GPUDevice::InstallInterfaceTemplate,
    nullptr,
    "GPUDevice",
    V8EventTarget::GetWrapperTypeInfo(),
    V8GPUDevice::kThisTag,
    V8GPUDevice::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& GPUDevice::wrapper_type_info_ =
    V8GPUDevice::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, GPUDevice>::value,
    "GPUDevice inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_gpu_device {


void FeaturesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_features_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.features.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->features();
static_assert(bindings::IsReturnTypeCompatible<GPUSupportedFeatures, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LimitsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_limits_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.limits.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->limits();
static_assert(bindings::IsReturnTypeCompatible<GPUSupportedLimits, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void AdapterInfoAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_adapterInfo_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.adapterInfo.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->adapterInfo();
static_assert(bindings::IsReturnTypeCompatible<GPUAdapterInfo, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LostAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  // Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8GPUDevice::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_lost_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.lost.get");


GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->lost(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<GPUDeviceLostInfo>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}



void QueueAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_queue_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.queue.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->queue();
static_assert(bindings::IsReturnTypeCompatible<GPUQueue, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void OnuncapturederrorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_onuncapturederror_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.onuncapturederror.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onuncapturederror();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnuncapturederrorAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_onuncapturederror_Setter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.onuncapturederror.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnuncapturederror(event_handler);
}


void LabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_label_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.label.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->label();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_label_Setter");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.label.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLabel(arg1_value);

}

void CreateBindGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createBindGroup");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createBindGroup");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUBindGroupDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createBindGroup(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUBindGroup, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateBindGroupLayoutOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createBindGroupLayout");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createBindGroupLayout");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUBindGroupLayoutDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createBindGroupLayout(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUBindGroupLayout, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createBuffer");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUBufferDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createBuffer(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateCommandEncoderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createCommandEncoder");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createCommandEncoder");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<GPUCommandEncoderDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
if (info[0]->IsUndefined()) {
  arg1_descriptor = GPUCommandEncoderDescriptor::Create();
} else {
  ExceptionState exception_state(isolate);
arg1_descriptor = NativeValueTraits<GPUCommandEncoderDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->createCommandEncoder(arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPUCommandEncoder, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateComputePipelineOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createComputePipeline");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createComputePipeline");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUComputePipelineDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createComputePipeline(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUComputePipeline, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateComputePipelineAsyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createComputePipelineAsync");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createComputePipelineAsync");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8GPUDevice::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "GPUDevice";
const char* const property_name = "createComputePipelineAsync";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_descriptor = NativeValueTraits<GPUComputePipelineDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createComputePipelineAsync(script_state, arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<GPUComputePipeline>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void CreatePipelineLayoutOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createPipelineLayout");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createPipelineLayout");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUPipelineLayoutDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createPipelineLayout(arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPUPipelineLayout, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateQuerySetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createQuerySet");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createQuerySet");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUQuerySetDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createQuerySet(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUQuerySet, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateRenderBundleEncoderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createRenderBundleEncoder");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createRenderBundleEncoder");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPURenderBundleEncoderDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createRenderBundleEncoder(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPURenderBundleEncoder, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateRenderPipelineOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createRenderPipeline");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createRenderPipeline");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPURenderPipelineDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createRenderPipeline(script_state, arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPURenderPipeline, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateRenderPipelineAsyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createRenderPipelineAsync");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createRenderPipelineAsync");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8GPUDevice::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "GPUDevice";
const char* const property_name = "createRenderPipelineAsync";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_descriptor = NativeValueTraits<GPURenderPipelineDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createRenderPipelineAsync(script_state, arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<GPURenderPipeline>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CreateSamplerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createSampler");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createSampler");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<GPUSamplerDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
if (info[0]->IsUndefined()) {
  arg1_descriptor = GPUSamplerDescriptor::Create();
} else {
  ExceptionState exception_state(isolate);
arg1_descriptor = NativeValueTraits<GPUSamplerDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->createSampler(arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPUSampler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateShaderModuleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createShaderModule");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createShaderModule");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUShaderModuleDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createShaderModule(arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPUShaderModule, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_createTexture");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.createTexture");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUTextureDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createTexture(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUTexture, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void DestroyOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_destroy");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.destroy");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->destroy(isolate);

}

void ImportExternalTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_importExternalTexture");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.importExternalTexture");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPUExternalTextureDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->importExternalTexture(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUExternalTexture, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void PopErrorScopeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_popErrorScope");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.popErrorScope");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8GPUDevice::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}




GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->popErrorScope(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLNullable<GPUError>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void PushErrorScopeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUDevice_pushErrorScope");
BLINK_BINDINGS_TRACE_EVENT("GPUDevice.pushErrorScope");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUDevice* blink_receiver = V8GPUDevice::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_filter = NativeValueTraits<V8GPUErrorFilter>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pushErrorScope(arg1_filter);

}


}  // namespace v8_gpu_device

using namespace v8_gpu_device;

}  // namespace 

void V8GPUDevice::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8GPUDevice::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8GPUDevice::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"features", FeaturesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"limits", LimitsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"adapterInfo", AdapterInfoAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"lost", LostAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"queue", QueueAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onuncapturederror", OnuncapturederrorAttributeGetCallback, OnuncapturederrorAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"label", LabelAttributeGetCallback, LabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUDevice", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"createBindGroup", CreateBindGroupOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createBindGroupLayout", CreateBindGroupLayoutOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createBuffer", CreateBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createCommandEncoder", CreateCommandEncoderOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createComputePipeline", CreateComputePipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createComputePipelineAsync", CreateComputePipelineAsyncOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createPipelineLayout", CreatePipelineLayoutOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createQuerySet", CreateQuerySetOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createRenderBundleEncoder", CreateRenderBundleEncoderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createRenderPipeline", CreateRenderPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createRenderPipelineAsync", CreateRenderPipelineAsyncOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createSampler", CreateSamplerOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createShaderModule", CreateShaderModuleOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createTexture", CreateTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"destroy", DestroyOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"importExternalTexture", ImportExternalTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"popErrorScope", PopErrorScopeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pushErrorScope", PushErrorScopeOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUDevice", kOperationTable);
}



}




}  // namespace blink
