// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_DEPTH_STENCIL_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_DEPTH_STENCIL_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compare_function.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUStencilFaceState;

class MODULES_EXPORT GPUDepthStencilState : public bindings::InputDictionaryBase {
  
  public:
static GPUDepthStencilState* Create() {
  return MakeGarbageCollected<GPUDepthStencilState>();
}
static GPUDepthStencilState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUDepthStencilState>(isolate);
}
static GPUDepthStencilState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUDepthStencilState();
explicit  GPUDepthStencilState(v8::Isolate* isolate);

bool hasDepthBias() const {
  return true;
}
int32_t depthBias() const {
  return member_depth_bias_;
}
void setDepthBias(int32_t value) {
  member_depth_bias_ = value;
}

bool hasDepthBiasClamp() const {
  return true;
}
float depthBiasClamp() const {
  return member_depth_bias_clamp_;
}
void setDepthBiasClamp(float value) {
  member_depth_bias_clamp_ = value;
}

bool hasDepthBiasSlopeScale() const {
  return true;
}
float depthBiasSlopeScale() const {
  return member_depth_bias_slope_scale_;
}
void setDepthBiasSlopeScale(float value) {
  member_depth_bias_slope_scale_ = value;
}

bool hasDepthCompare() const {
  return has_depth_compare_;
}
V8GPUCompareFunction depthCompare() const {
  DCHECK(hasDepthCompare());
return member_depth_compare_;
}
V8GPUCompareFunction getDepthCompareOr(V8GPUCompareFunction fallback_value) const {
  if (!hasDepthCompare()) {
  return fallback_value;
}
return member_depth_compare_;
}
void setDepthCompare(V8GPUCompareFunction value) {
  member_depth_compare_ = value;
has_depth_compare_ = true;
}
void setDepthCompare(V8GPUCompareFunction::Enum value) {
  member_depth_compare_ = V8GPUCompareFunction(value);
has_depth_compare_ = true;
}

bool hasDepthWriteEnabled() const {
  return has_depth_write_enabled_;
}
bool depthWriteEnabled() const {
  DCHECK(hasDepthWriteEnabled());
return member_depth_write_enabled_;
}
bool getDepthWriteEnabledOr(bool fallback_value) const {
  if (!hasDepthWriteEnabled()) {
  return fallback_value;
}
return member_depth_write_enabled_;
}
void setDepthWriteEnabled(bool value) {
  member_depth_write_enabled_ = value;
has_depth_write_enabled_ = true;
}

bool hasFormat() const {
  return true;
}
V8GPUTextureFormat format() const {
  return member_format_;
}
void setFormat(V8GPUTextureFormat value) {
  member_format_ = value;
}
void setFormat(V8GPUTextureFormat::Enum value) {
  member_format_ = V8GPUTextureFormat(value);
}

bool hasStencilBack() const {
  return true;
}
GPUStencilFaceState* stencilBack() const {
  return member_stencil_back_.Get();
}
void setStencilBack(GPUStencilFaceState* value) {
  member_stencil_back_ = value;
DCHECK(member_stencil_back_);
}

bool hasStencilFront() const {
  return true;
}
GPUStencilFaceState* stencilFront() const {
  return member_stencil_front_.Get();
}
void setStencilFront(GPUStencilFaceState* value) {
  member_stencil_front_ = value;
DCHECK(member_stencil_front_);
}

bool hasStencilReadMask() const {
  return true;
}
uint32_t stencilReadMask() const {
  return member_stencil_read_mask_;
}
void setStencilReadMask(uint32_t value) {
  member_stencil_read_mask_ = value;
}

bool hasStencilWriteMask() const {
  return true;
}
uint32_t stencilWriteMask() const {
  return member_stencil_write_mask_;
}
void setStencilWriteMask(uint32_t value) {
  member_stencil_write_mask_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_compare_ = false;
bool has_depth_write_enabled_ = false;

int32_t member_depth_bias_{0};
float member_depth_bias_clamp_{0};
float member_depth_bias_slope_scale_{0};
V8GPUCompareFunction member_depth_compare_{static_cast<V8GPUCompareFunction::Enum>(0)};
bool member_depth_write_enabled_;
V8GPUTextureFormat member_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
Member<GPUStencilFaceState> member_stencil_back_;
Member<GPUStencilFaceState> member_stencil_front_;
uint32_t member_stencil_read_mask_{0xFFFFFFFF};
uint32_t member_stencil_write_mask_{0xFFFFFFFF};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_DEPTH_STENCIL_STATE_H_
