// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pass_encoder.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_bind_group.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_compute_pass_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_compute_pipeline.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_query_set.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8GPUComputePassEncoder::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope());
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8GPUComputePassEncoder::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8GPUComputePassEncoder::InstallInterfaceTemplate,
    nullptr,
    "GPUComputePassEncoder",
    nullptr,
    V8GPUComputePassEncoder::kThisTag,
    V8GPUComputePassEncoder::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& GPUComputePassEncoder::wrapper_type_info_ =
    V8GPUComputePassEncoder::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, GPUComputePassEncoder>::value,
    "GPUComputePassEncoder inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_gpu_compute_pass_encoder {


void LabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_label_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.label.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->label();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_label_Setter");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.label.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLabel(arg1_value);

}

void DispatchWorkgroupsOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_workgroup_count_x, uint32_t v8_arg2_workgroup_count_y, uint32_t v8_arg3_workgroup_count_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_workgroup_count_x = v8_arg1_workgroup_count_x;
auto&& arg2_workgroup_count_y = v8_arg2_workgroup_count_y;
auto&& arg3_workgroup_count_z = v8_arg3_workgroup_count_z;
blink_receiver->dispatchWorkgroups(arg1_workgroup_count_x, arg2_workgroup_count_y, arg3_workgroup_count_z);
}

void DispatchWorkgroupsOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_workgroup_count_x, uint32_t v8_arg2_workgroup_count_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_workgroup_count_x = v8_arg1_workgroup_count_x;
auto&& arg2_workgroup_count_y = v8_arg2_workgroup_count_y;
auto&& arg3_workgroup_count_z{1};
blink_receiver->dispatchWorkgroups(arg1_workgroup_count_x, arg2_workgroup_count_y, arg3_workgroup_count_z);
}

void DispatchWorkgroupsOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_workgroup_count_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_workgroup_count_x = v8_arg1_workgroup_count_x;
auto&& arg2_workgroup_count_y{1};
auto&& arg3_workgroup_count_z{1};
blink_receiver->dispatchWorkgroups(arg1_workgroup_count_x, arg2_workgroup_count_y, arg3_workgroup_count_z);
}

void DispatchWorkgroupsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_dispatchWorkgroups");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.dispatchWorkgroups");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_workgroup_count_x = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_workgroup_count_y{1};
if (!info[1]->IsUndefined()) {
  arg2_workgroup_count_y = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_workgroup_count_z{1};
if (!info[2]->IsUndefined()) {
  arg3_workgroup_count_z = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->dispatchWorkgroups(arg1_workgroup_count_x, arg2_workgroup_count_y, arg3_workgroup_count_z);

}

void DispatchWorkgroupsIndirectOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
blink_receiver->dispatchWorkgroupsIndirect(arg1_indirect_buffer, arg2_indirect_offset);
}

void DispatchWorkgroupsIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_dispatchWorkgroupsIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.dispatchWorkgroupsIndirect");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->dispatchWorkgroupsIndirect(arg1_indirect_buffer, arg2_indirect_offset);

}

void EndOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->end();
}

void EndOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_end");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.end");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->end();

}

void InsertDebugMarkerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_insertDebugMarker");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.insertDebugMarker");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_marker_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->insertDebugMarker(arg1_marker_label);

}

void PopDebugGroupOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();
}

void PopDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_popDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.popDebugGroup");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();

}

void PushDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_pushDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.pushDebugGroup");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_group_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pushDebugGroup(arg1_group_label);

}

void SetBindGroupOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::Local<v8::Value> v8_arg3_dynamic_offsets, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets = NativeValueTraits<IDLSequence<IDLUnsignedLongEnforceRange>>::ArgumentValue(isolate, 2, v8_arg3_dynamic_offsets, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets);
}

void SetBindGroupOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group);
}

void SetBindGroupOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::Local<v8::Value> v8_arg3_dynamic_offsets_data, uint64_t v8_arg4_dynamic_offsets_data_start, uint32_t v8_arg5_dynamic_offsets_data_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, v8_arg3_dynamic_offsets_data, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dynamic_offsets_data_start = v8_arg4_dynamic_offsets_data_start;
auto&& arg5_dynamic_offsets_data_length = v8_arg5_dynamic_offsets_data_length;
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets_data, arg4_dynamic_offsets_data_start, arg5_dynamic_offsets_data_length, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void SetBindGroupOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->setBindGroup(arg1_index, arg2_bind_group);
break;
}
auto&& arg3_dynamic_offsets = NativeValueTraits<IDLSequence<IDLUnsignedLongEnforceRange>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, std::move(arg3_dynamic_offsets));
} while (false);

}

void SetBindGroupOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dynamic_offsets_data_start = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_dynamic_offsets_data_length = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets_data, arg4_dynamic_offsets_data_start, arg5_dynamic_offsets_data_length, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetBindGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_setBindGroup");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.setBindGroup");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return SetBindGroupOperationOverload2(info);
}
if (arg_count == 3) {
  return SetBindGroupOperationOverload1(info);
}
if (arg_count == 2) {
  return SetBindGroupOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetImmediatesOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_range_offset = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<DOMArrayBufferBase>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_data_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_data_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, exception_state);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, arg4_size, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetImmediatesOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_range_offset = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_data_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_data_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, exception_state);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setImmediates(arg1_range_offset, arg2_data, arg3_data_offset, arg4_size, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetImmediatesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_setImmediates");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.setImmediates");


const int arg_count = std::min(info.Length(), 4);
do {  // Dummy loop for use of 'break'.
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (arg_count == 4) {
  if (info[1]->IsObject()) {
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return SetImmediatesOperationOverload1(info);
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBufferView()) {
  return SetImmediatesOperationOverload2(info);
}
}
}
break;
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (arg_count == 3) {
  if (info[1]->IsObject()) {
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return SetImmediatesOperationOverload1(info);
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBufferView()) {
  return SetImmediatesOperationOverload2(info);
}
}
}
break;
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (arg_count == 2) {
  if (info[1]->IsObject()) {
  if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return SetImmediatesOperationOverload1(info);
}
}
if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  if (info[1]->IsArrayBufferView()) {
  return SetImmediatesOperationOverload2(info);
}
}
}
break;
}
}
} while (false);

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetPipelineOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_pipeline, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pipeline = NativeValueTraits<GPUComputePipeline>::ArgumentValue(isolate, 0, v8_arg1_pipeline, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setPipeline(arg1_pipeline);
}

void SetPipelineOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_setPipeline");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.setPipeline");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pipeline = NativeValueTraits<GPUComputePipeline>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setPipeline(arg1_pipeline);

}

void WriteTimestampOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_query_set, uint32_t v8_arg2_query_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, v8_arg1_query_set, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query_index = v8_arg2_query_index;
blink_receiver->writeTimestamp(arg1_query_set, arg2_query_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void WriteTimestampOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUComputePassEncoder_writeTimestamp");
BLINK_BINDINGS_TRACE_EVENT("GPUComputePassEncoder.writeTimestamp");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUComputePassEncoder* blink_receiver = V8GPUComputePassEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->writeTimestamp(arg1_query_set, arg2_query_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_gpu_compute_pass_encoder

using namespace v8_gpu_compute_pass_encoder;

}  // namespace 

void V8GPUComputePassEncoder::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8GPUComputePassEncoder::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8GPUComputePassEncoder::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"label", LabelAttributeGetCallback, LabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUComputePassEncoder", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"insertDebugMarker", InsertDebugMarkerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pushDebugGroup", PushDebugGroupOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUComputePassEncoder", kOperationTable);
}


{
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"dispatchWorkgroups", DispatchWorkgroupsOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"dispatchWorkgroupsIndirect", DispatchWorkgroupsIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"end", EndOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setBindGroup", SetBindGroupOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setPipeline", SetPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"writeTimestamp", WriteTimestampOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = DispatchWorkgroupsOperationNoAllocDirectCallArg3;
std::ignore = DispatchWorkgroupsOperationNoAllocDirectCallArg2;
std::ignore = DispatchWorkgroupsOperationNoAllocDirectCallArg1;
std::ignore = DispatchWorkgroupsIndirectOperationNoAllocDirectCallArg2;
std::ignore = EndOperationNoAllocDirectCallArg0;
std::ignore = PopDebugGroupOperationNoAllocDirectCallArg0;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload1Arg3;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload1Arg2;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload2Arg5;
std::ignore = SetPipelineOperationNoAllocDirectCallArg1;
std::ignore = WriteTimestampOperationNoAllocDirectCallArg2;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfDispatchWorkgroups[] = {
v8::CFunctionBuilder().Fn(DispatchWorkgroupsOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DispatchWorkgroupsOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DispatchWorkgroupsOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDispatchWorkgroupsIndirect[] = {
v8::CFunctionBuilder().Fn(DispatchWorkgroupsIndirectOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEnd[] = {
v8::CFunctionBuilder().Fn(EndOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfPopDebugGroup[] = {
v8::CFunctionBuilder().Fn(PopDebugGroupOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetBindGroup[] = {
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload1Arg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload1Arg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload2Arg5).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetPipeline[] = {
v8::CFunctionBuilder().Fn(SetPipelineOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfWriteTimestamp[] = {
v8::CFunctionBuilder().Fn(WriteTimestampOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"dispatchWorkgroups", DispatchWorkgroupsOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDispatchWorkgroups, std::size(kNoAllocDirectCallOverloadsOfDispatchWorkgroups)}, 
{{"dispatchWorkgroupsIndirect", DispatchWorkgroupsIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDispatchWorkgroupsIndirect, std::size(kNoAllocDirectCallOverloadsOfDispatchWorkgroupsIndirect)}, 
{{"end", EndOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEnd, std::size(kNoAllocDirectCallOverloadsOfEnd)}, 
{{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfPopDebugGroup, std::size(kNoAllocDirectCallOverloadsOfPopDebugGroup)}, 
{{"setBindGroup", SetBindGroupOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetBindGroup, std::size(kNoAllocDirectCallOverloadsOfSetBindGroup)}, 
{{"setPipeline", SetPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetPipeline, std::size(kNoAllocDirectCallOverloadsOfSetPipeline)}, 
{{"writeTimestamp", WriteTimestampOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfWriteTimestamp, std::size(kNoAllocDirectCallOverloadsOfWriteTimestamp)}, 
};
#endif  // defined(ARCH_CPU_X86)
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUComputePassEncoder", kOperationTable);
}


}

void V8GPUComputePassEncoder::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





if (RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"setImmediates", SetImmediatesOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUComputePassEncoder", kOperationTable);
}


}



}  // namespace blink
