// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUBufferDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUBufferDescriptor* Create() {
  return MakeGarbageCollected<GPUBufferDescriptor>();
}
static GPUBufferDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBufferDescriptor>(isolate);
}
static GPUBufferDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBufferDescriptor();
explicit  GPUBufferDescriptor(v8::Isolate* isolate);

bool hasMappedAtCreation() const {
  return true;
}
bool mappedAtCreation() const {
  return member_mapped_at_creation_;
}
void setMappedAtCreation(bool value) {
  member_mapped_at_creation_ = value;
}

bool hasSize() const {
  return true;
}
uint64_t size() const {
  return member_size_;
}
void setSize(uint64_t value) {
  member_size_ = value;
}

bool hasUsage() const {
  return true;
}
uint32_t usage() const {
  return member_usage_;
}
void setUsage(uint32_t value) {
  member_usage_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_mapped_at_creation_{false};
uint64_t member_size_;
uint32_t member_usage_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_DESCRIPTOR_H_
