// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_RAW_INPUT_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_RAW_INPUT_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gamepad_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GamepadRawInputChangeEventInit : public GamepadEventInit {
  
  public:
static GamepadRawInputChangeEventInit* Create() {
  return MakeGarbageCollected<GamepadRawInputChangeEventInit>();
}
static GamepadRawInputChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GamepadRawInputChangeEventInit>(isolate);
}
static GamepadRawInputChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GamepadRawInputChangeEventInit();
explicit  GamepadRawInputChangeEventInit(v8::Isolate* isolate);

bool hasAxesChanged() const {
  return has_axes_changed_;
}
const Vector<int32_t>& axesChanged() const {
  DCHECK(hasAxesChanged());
return member_axes_changed_;
}
Vector<int32_t> getAxesChangedOr(const Vector<int32_t>& fallback_value) const;
Vector<int32_t> getAxesChangedOr(Vector<int32_t>&& fallback_value) const;
void setAxesChanged(const Vector<int32_t>& value);
void setAxesChanged(Vector<int32_t>&& value);

bool hasButtonsPressed() const {
  return has_buttons_pressed_;
}
const Vector<int32_t>& buttonsPressed() const {
  DCHECK(hasButtonsPressed());
return member_buttons_pressed_;
}
Vector<int32_t> getButtonsPressedOr(const Vector<int32_t>& fallback_value) const;
Vector<int32_t> getButtonsPressedOr(Vector<int32_t>&& fallback_value) const;
void setButtonsPressed(const Vector<int32_t>& value);
void setButtonsPressed(Vector<int32_t>&& value);

bool hasButtonsReleased() const {
  return has_buttons_released_;
}
const Vector<int32_t>& buttonsReleased() const {
  DCHECK(hasButtonsReleased());
return member_buttons_released_;
}
Vector<int32_t> getButtonsReleasedOr(const Vector<int32_t>& fallback_value) const;
Vector<int32_t> getButtonsReleasedOr(Vector<int32_t>&& fallback_value) const;
void setButtonsReleased(const Vector<int32_t>& value);
void setButtonsReleased(Vector<int32_t>&& value);

bool hasButtonsValueChanged() const {
  return has_buttons_value_changed_;
}
const Vector<int32_t>& buttonsValueChanged() const {
  DCHECK(hasButtonsValueChanged());
return member_buttons_value_changed_;
}
Vector<int32_t> getButtonsValueChangedOr(const Vector<int32_t>& fallback_value) const;
Vector<int32_t> getButtonsValueChangedOr(Vector<int32_t>&& fallback_value) const;
void setButtonsValueChanged(const Vector<int32_t>& value);
void setButtonsValueChanged(Vector<int32_t>&& value);

bool hasTouchesChanged() const {
  return has_touches_changed_;
}
const Vector<int32_t>& touchesChanged() const {
  DCHECK(hasTouchesChanged());
return member_touches_changed_;
}
Vector<int32_t> getTouchesChangedOr(const Vector<int32_t>& fallback_value) const;
Vector<int32_t> getTouchesChangedOr(Vector<int32_t>&& fallback_value) const;
void setTouchesChanged(const Vector<int32_t>& value);
void setTouchesChanged(Vector<int32_t>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GamepadEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_axes_changed_ = false;
bool has_buttons_pressed_ = false;
bool has_buttons_released_ = false;
bool has_buttons_value_changed_ = false;
bool has_touches_changed_ = false;

Vector<int32_t> member_axes_changed_;
Vector<int32_t> member_buttons_pressed_;
Vector<int32_t> member_buttons_released_;
Vector<int32_t> member_buttons_value_changed_;
Vector<int32_t> member_touches_changed_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_RAW_INPUT_CHANGE_EVENT_INIT_H_
