// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gamepad_raw_input_change_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"axesChanged",
"buttonsPressed",
"buttonsReleased",
"buttonsValueChanged",
"touchesChanged",
};


}  // namespace 

GamepadRawInputChangeEventInit* GamepadRawInputChangeEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GamepadRawInputChangeEventInit* dictionary = MakeGarbageCollected<GamepadRawInputChangeEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GamepadRawInputChangeEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GamepadRawInputChangeEventInit::GamepadRawInputChangeEventInit() {
  
}

 GamepadRawInputChangeEventInit::GamepadRawInputChangeEventInit(v8::Isolate* isolate) : GamepadEventInit(isolate) {
  
}



Vector<int32_t> GamepadRawInputChangeEventInit::getAxesChangedOr(const Vector<int32_t>& fallback_value) const {
  if (!hasAxesChanged()) {
  return fallback_value;
}
return member_axes_changed_;
}

Vector<int32_t> GamepadRawInputChangeEventInit::getAxesChangedOr(Vector<int32_t>&& fallback_value) const {
  if (!hasAxesChanged()) {
  return std::move(fallback_value);
}
return member_axes_changed_;
}

void GamepadRawInputChangeEventInit::setAxesChanged(const Vector<int32_t>& value) {
  member_axes_changed_ = value;
has_axes_changed_ = true;
}

void GamepadRawInputChangeEventInit::setAxesChanged(Vector<int32_t>&& value) {
  member_axes_changed_ = std::move(value);
has_axes_changed_ = true;
}




Vector<int32_t> GamepadRawInputChangeEventInit::getButtonsPressedOr(const Vector<int32_t>& fallback_value) const {
  if (!hasButtonsPressed()) {
  return fallback_value;
}
return member_buttons_pressed_;
}

Vector<int32_t> GamepadRawInputChangeEventInit::getButtonsPressedOr(Vector<int32_t>&& fallback_value) const {
  if (!hasButtonsPressed()) {
  return std::move(fallback_value);
}
return member_buttons_pressed_;
}

void GamepadRawInputChangeEventInit::setButtonsPressed(const Vector<int32_t>& value) {
  member_buttons_pressed_ = value;
has_buttons_pressed_ = true;
}

void GamepadRawInputChangeEventInit::setButtonsPressed(Vector<int32_t>&& value) {
  member_buttons_pressed_ = std::move(value);
has_buttons_pressed_ = true;
}




Vector<int32_t> GamepadRawInputChangeEventInit::getButtonsReleasedOr(const Vector<int32_t>& fallback_value) const {
  if (!hasButtonsReleased()) {
  return fallback_value;
}
return member_buttons_released_;
}

Vector<int32_t> GamepadRawInputChangeEventInit::getButtonsReleasedOr(Vector<int32_t>&& fallback_value) const {
  if (!hasButtonsReleased()) {
  return std::move(fallback_value);
}
return member_buttons_released_;
}

void GamepadRawInputChangeEventInit::setButtonsReleased(const Vector<int32_t>& value) {
  member_buttons_released_ = value;
has_buttons_released_ = true;
}

void GamepadRawInputChangeEventInit::setButtonsReleased(Vector<int32_t>&& value) {
  member_buttons_released_ = std::move(value);
has_buttons_released_ = true;
}




Vector<int32_t> GamepadRawInputChangeEventInit::getButtonsValueChangedOr(const Vector<int32_t>& fallback_value) const {
  if (!hasButtonsValueChanged()) {
  return fallback_value;
}
return member_buttons_value_changed_;
}

Vector<int32_t> GamepadRawInputChangeEventInit::getButtonsValueChangedOr(Vector<int32_t>&& fallback_value) const {
  if (!hasButtonsValueChanged()) {
  return std::move(fallback_value);
}
return member_buttons_value_changed_;
}

void GamepadRawInputChangeEventInit::setButtonsValueChanged(const Vector<int32_t>& value) {
  member_buttons_value_changed_ = value;
has_buttons_value_changed_ = true;
}

void GamepadRawInputChangeEventInit::setButtonsValueChanged(Vector<int32_t>&& value) {
  member_buttons_value_changed_ = std::move(value);
has_buttons_value_changed_ = true;
}




Vector<int32_t> GamepadRawInputChangeEventInit::getTouchesChangedOr(const Vector<int32_t>& fallback_value) const {
  if (!hasTouchesChanged()) {
  return fallback_value;
}
return member_touches_changed_;
}

Vector<int32_t> GamepadRawInputChangeEventInit::getTouchesChangedOr(Vector<int32_t>&& fallback_value) const {
  if (!hasTouchesChanged()) {
  return std::move(fallback_value);
}
return member_touches_changed_;
}

void GamepadRawInputChangeEventInit::setTouchesChanged(const Vector<int32_t>& value) {
  member_touches_changed_ = value;
has_touches_changed_ = true;
}

void GamepadRawInputChangeEventInit::setTouchesChanged(Vector<int32_t>&& value) {
  member_touches_changed_ = std::move(value);
has_touches_changed_ = true;
}



void GamepadRawInputChangeEventInit::Trace(Visitor* visitor) const {
  GamepadEventInit::Trace(visitor);
}

void GamepadRawInputChangeEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
GamepadEventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "GamepadRawInputChangeEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("axesChanged");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLArray<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_axes_changed_, member_axes_changed_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("buttonsPressed");
if (!bindings::GetDictionaryMemberFromV8Object<IDLArray<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_buttons_pressed_, member_buttons_pressed_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("buttonsReleased");
if (!bindings::GetDictionaryMemberFromV8Object<IDLArray<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_buttons_released_, member_buttons_released_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("buttonsValueChanged");
if (!bindings::GetDictionaryMemberFromV8Object<IDLArray<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_buttons_value_changed_, member_buttons_value_changed_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("touchesChanged");
if (!bindings::GetDictionaryMemberFromV8Object<IDLArray<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_touches_changed_, member_touches_changed_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GamepadRawInputChangeEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
