// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ENCODED_VIDEO_CHUNK_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ENCODED_VIDEO_CHUNK_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_encoded_video_chunk_type.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DecryptConfig;
class ExceptionState;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared;

class MODULES_EXPORT EncodedVideoChunkInit : public bindings::InputDictionaryBase {
  
  public:
static EncodedVideoChunkInit* Create() {
  return MakeGarbageCollected<EncodedVideoChunkInit>();
}
static EncodedVideoChunkInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<EncodedVideoChunkInit>(isolate);
}
static EncodedVideoChunkInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  EncodedVideoChunkInit();
explicit  EncodedVideoChunkInit(v8::Isolate* isolate);

bool hasData() const {
  return true;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* data() const {
  return member_data_.Get();
}
void setData(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  member_data_ = value;
DCHECK(member_data_);
}

bool hasDecryptConfig() const {
  return has_decrypt_config_;
}
DecryptConfig* decryptConfig() const {
  DCHECK(hasDecryptConfig());
return member_decrypt_config_.Get();
}
DecryptConfig* getDecryptConfigOr(DecryptConfig* fallback_value) const {
  if (!hasDecryptConfig()) {
  return fallback_value;
}
return member_decrypt_config_.Get();
}
void setDecryptConfig(DecryptConfig* value) {
  member_decrypt_config_ = value;
has_decrypt_config_ = true;
DCHECK(member_decrypt_config_);
}

bool hasDuration() const {
  return has_duration_;
}
uint64_t duration() const {
  DCHECK(hasDuration());
return member_duration_;
}
uint64_t getDurationOr(uint64_t fallback_value) const {
  if (!hasDuration()) {
  return fallback_value;
}
return member_duration_;
}
void setDuration(uint64_t value) {
  member_duration_ = value;
has_duration_ = true;
}

bool hasTimestamp() const {
  return true;
}
int64_t timestamp() const {
  return member_timestamp_;
}
void setTimestamp(int64_t value) {
  member_timestamp_ = value;
}

bool hasTransfer() const {
  return true;
}
const HeapVector<Member<DOMArrayBuffer>>& transfer() const {
  return member_transfer_;
}
void setTransfer(const HeapVector<Member<DOMArrayBuffer>>& value);
void setTransfer(HeapVector<Member<DOMArrayBuffer>>&& value);

bool hasType() const {
  return true;
}
V8EncodedVideoChunkType type() const {
  return member_type_;
}
void setType(V8EncodedVideoChunkType value) {
  member_type_ = value;
}
void setType(V8EncodedVideoChunkType::Enum value) {
  member_type_ = V8EncodedVideoChunkType(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_decrypt_config_ = false;
bool has_duration_ = false;

Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared> member_data_;
Member<DecryptConfig> member_decrypt_config_;
uint64_t member_duration_;
int64_t member_timestamp_;
HeapVector<Member<DOMArrayBuffer>> member_transfer_;
V8EncodedVideoChunkType member_type_{static_cast<V8EncodedVideoChunkType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ENCODED_VIDEO_CHUNK_INIT_H_
