// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_dedicated_worker_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abort_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abort_signal.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_x.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_y.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_custom_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_exception.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_point.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_point_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_quad.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_rect.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_rect_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_string_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_error_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file_reader_sync.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_font_face.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_font_face_set.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_form_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_frame_request_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_headers.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_channel.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_port.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_handle.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_interface_interceptor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_interface_request_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_watcher.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigator_ua_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_origin.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_entry.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_mark.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_measure.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_observer.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_observer_entry_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_resource_timing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_server_timing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_post_message_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_progress_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_promise_rejection_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_report_body.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_reporting_observer.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_response.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scheduler.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_security_policy_violation_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_subscriber.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_priority_change_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_signal.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_cluster.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_metrics.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_html.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_type_policy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_type_policy_factory.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_search_params.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_user_activation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_location.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_navigator.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_xml_http_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_xml_http_request_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_xml_http_request_upload.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_record.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_registration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_barcode_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_broadcast_channel.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cache.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cache_storage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_filter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_gradient.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_pattern.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_close_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_compression_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_content_index.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_create_monitor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crop_target.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto_key.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_decompression_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_dom_file_system_sync.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_encoded_audio_chunk.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_encoded_video_chunk.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_entry_callback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_entry_sync.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_error_callback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_event_source.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_face_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_callback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_directory_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_file_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_observer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_sync_access_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_writable_file_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_adapter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_adapter_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer_usage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_color_write.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compilation_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compilation_message.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pass_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device_lost_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_external_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_heap_property.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_internal_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_map_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_memory_heap_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_out_of_memory_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_queue.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_module.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_stage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_subgroup_matrix_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_features.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_usage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_uncaptured_error_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_validation_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_connection_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_device.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_input_report_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_cursor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_cursor_with_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_database.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_factory.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_index.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_key_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_object_store.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_open_db_request.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_record.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_request.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_transaction.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_version_change_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idle_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_bitmap_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_track.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_track_list.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_params.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_capabilities.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_source.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_source_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_index_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_uv_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_vertex_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_graph.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_graph_builder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operand.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_tensor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_multicast_controller.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_navigation_preload_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_network_information.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_offscreen_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_path_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_periodic_sync_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_permission_status.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_permissions.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_pressure_observer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_pressure_record.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_proofreader.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_subscription.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_subscription_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_restriction_target.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rewriter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_data_channel.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_audio_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_video_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_received_packet.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_script_transformer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transform_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_ice_candidate.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_ice_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_serial.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_serial_port.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_container.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_registration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_source_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_source_buffer_list.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_bucket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_bucket_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_subtle_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_summarizer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_sync_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_tcp_server_socket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_tcp_socket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_timestamp_trigger.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_translator.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_udp_socket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_alternate_interface.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_configuration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_connection_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_device.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_endpoint.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_in_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_interface.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_in_transfer_packet.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_in_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_out_transfer_packet.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_out_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_out_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_color_space.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_wake_lock.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_wake_lock_sentinel.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_bidirectional_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_datagram_duplex_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context_webgpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_active_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_context_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_framebuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_object.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_program.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_query.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_renderbuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context_webgpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader_precision_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_sync.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_transform_feedback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_uniform_location.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_vertex_array_object.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_wgsl_language_features.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_writer.h"
#include "third_party/blink/renderer/core/context_features/context_feature_settings.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/workers/dedicated_worker_global_scope.h"
#include "third_party/blink/renderer/modules/filesystem/dom_file_system_sync.h"
#include "third_party/blink/renderer/modules/filesystem/entry_sync.h"
#include "third_party/blink/renderer/modules/filesystem/worker_global_scope_file_system.h"
#include "third_party/blink/renderer/modules/peerconnection/dedicated_worker_global_scope_rtc_transform.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



void V8DedicatedWorkerGlobalScope::Impl::Init() {
  V8DedicatedWorkerGlobalScope::install_interface_template_func_ = InstallInterfaceTemplate;
V8DedicatedWorkerGlobalScope::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8DedicatedWorkerGlobalScope::install_context_independent_props_func_ = InstallContextIndependentProperties;
V8DedicatedWorkerGlobalScope::install_context_dependent_props_func_ = InstallContextDependentProperties;
}

namespace  {

namespace v8_dedicated_worker_global_scope {


void NameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_name_Getter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.name.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->name();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void NameAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_name_Setter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.name.set");

// [Replaceable]
bool did_create;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "name";
v8::Local<v8::Value> v8_property_value = info[0];
if (!v8_receiver->CreateDataProperty(current_context, V8AtomicString(isolate, property_name), v8_property_value).To(&did_create)) {
  return;
}
}


void OnmessageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_onmessage_Getter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.onmessage.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onmessage();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnmessageAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_onmessage_Setter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.onmessage.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnmessage(event_handler);
}


void OnmessageerrorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_onmessageerror_Getter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.onmessageerror.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onmessageerror();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnmessageerrorAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_onmessageerror_Setter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.onmessageerror.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnmessageerror(event_handler);
}


void OnrtctransformAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_onrtctransform_Getter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.onrtctransform.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = DedicatedWorkerGlobalScopeRTCTransform::onrtctransform(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnrtctransformAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_onrtctransform_Setter");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.onrtctransform.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
DedicatedWorkerGlobalScopeRTCTransform::setOnrtctransform(*blink_receiver, event_handler);
}

void AbortControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_AbortController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.AbortController");

bindings::V8SetReturnValue(info, V8AbortController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AbortSignalExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_AbortSignal_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.AbortSignal");

bindings::V8SetReturnValue(info, V8AbortSignal::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AudioDataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_AudioData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.AudioData");

bindings::V8SetReturnValue(info, V8AudioData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AudioDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_AudioDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.AudioDecoder");

bindings::V8SetReturnValue(info, V8AudioDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AudioEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_AudioEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.AudioEncoder");

bindings::V8SetReturnValue(info, V8AudioEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_BackgroundFetchManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.BackgroundFetchManager");

bindings::V8SetReturnValue(info, V8BackgroundFetchManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchRecordExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_BackgroundFetchRecord_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.BackgroundFetchRecord");

bindings::V8SetReturnValue(info, V8BackgroundFetchRecord::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchRegistrationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_BackgroundFetchRegistration_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.BackgroundFetchRegistration");

bindings::V8SetReturnValue(info, V8BackgroundFetchRegistration::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BarcodeDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_BarcodeDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.BarcodeDetector");

bindings::V8SetReturnValue(info, V8BarcodeDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BlobExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Blob_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Blob");

bindings::V8SetReturnValue(info, V8Blob::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BroadcastChannelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_BroadcastChannel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.BroadcastChannel");

bindings::V8SetReturnValue(info, V8BroadcastChannel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewXExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CSSSkewX_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CSSSkewX");

bindings::V8SetReturnValue(info, V8CSSSkewX::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewYExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CSSSkewY_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CSSSkewY");

bindings::V8SetReturnValue(info, V8CSSSkewY::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CacheExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Cache_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Cache");

bindings::V8SetReturnValue(info, V8Cache::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CacheStorageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CacheStorage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CacheStorage");

bindings::V8SetReturnValue(info, V8CacheStorage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasFilterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CanvasFilter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CanvasFilter");

bindings::V8SetReturnValue(info, V8CanvasFilter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasGradientExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CanvasGradient_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CanvasGradient");

bindings::V8SetReturnValue(info, V8CanvasGradient::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasPatternExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CanvasPattern_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CanvasPattern");

bindings::V8SetReturnValue(info, V8CanvasPattern::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CloseEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CloseEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CloseEvent");

bindings::V8SetReturnValue(info, V8CloseEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CompressionStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CompressionStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CompressionStream");

bindings::V8SetReturnValue(info, V8CompressionStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ContentIndexExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ContentIndex_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ContentIndex");

bindings::V8SetReturnValue(info, V8ContentIndex::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CreateMonitorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CreateMonitor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CreateMonitor");

bindings::V8SetReturnValue(info, V8CreateMonitor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CropTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CropTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CropTarget");

bindings::V8SetReturnValue(info, V8CropTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CryptoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Crypto_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Crypto");

bindings::V8SetReturnValue(info, V8Crypto::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CryptoKeyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CryptoKey_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CryptoKey");

bindings::V8SetReturnValue(info, V8CryptoKey::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CustomEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_CustomEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.CustomEvent");

bindings::V8SetReturnValue(info, V8CustomEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMExceptionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMException_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMException");

bindings::V8SetReturnValue(info, V8DOMException::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMMatrixExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMMatrix_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMMatrix");

bindings::V8SetReturnValue(info, V8DOMMatrix::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMMatrixReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMMatrixReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMMatrixReadOnly");

bindings::V8SetReturnValue(info, V8DOMMatrixReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMPointExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMPoint_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMPoint");

bindings::V8SetReturnValue(info, V8DOMPoint::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMPointReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMPointReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMPointReadOnly");

bindings::V8SetReturnValue(info, V8DOMPointReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMQuadExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMQuad_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMQuad");

bindings::V8SetReturnValue(info, V8DOMQuad::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMRectExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMRect_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMRect");

bindings::V8SetReturnValue(info, V8DOMRect::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMRectReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMRectReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMRectReadOnly");

bindings::V8SetReturnValue(info, V8DOMRectReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMStringListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DOMStringList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DOMStringList");

bindings::V8SetReturnValue(info, V8DOMStringList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DecompressionStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DecompressionStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DecompressionStream");

bindings::V8SetReturnValue(info, V8DecompressionStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DedicatedWorkerGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_DedicatedWorkerGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.DedicatedWorkerGlobalScope");

bindings::V8SetReturnValue(info, V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EncodedAudioChunkExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_EncodedAudioChunk_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.EncodedAudioChunk");

bindings::V8SetReturnValue(info, V8EncodedAudioChunk::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EncodedVideoChunkExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_EncodedVideoChunk_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.EncodedVideoChunk");

bindings::V8SetReturnValue(info, V8EncodedVideoChunk::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ErrorEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ErrorEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ErrorEvent");

bindings::V8SetReturnValue(info, V8ErrorEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Event_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Event");

bindings::V8SetReturnValue(info, V8Event::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventSourceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_EventSource_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.EventSource");

bindings::V8SetReturnValue(info, V8EventSource::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_EventTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.EventTarget");

bindings::V8SetReturnValue(info, V8EventTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FaceDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FaceDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FaceDetector");

bindings::V8SetReturnValue(info, V8FaceDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_File_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.File");

bindings::V8SetReturnValue(info, V8File::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileList");

bindings::V8SetReturnValue(info, V8FileList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileReader");

bindings::V8SetReturnValue(info, V8FileReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileReaderSyncExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileReaderSync_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileReaderSync");

bindings::V8SetReturnValue(info, V8FileReaderSync::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemDirectoryHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileSystemDirectoryHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileSystemDirectoryHandle");

bindings::V8SetReturnValue(info, V8FileSystemDirectoryHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemFileHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileSystemFileHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileSystemFileHandle");

bindings::V8SetReturnValue(info, V8FileSystemFileHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileSystemHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileSystemHandle");

bindings::V8SetReturnValue(info, V8FileSystemHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemObserverExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileSystemObserver_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileSystemObserver");

bindings::V8SetReturnValue(info, V8FileSystemObserver::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemSyncAccessHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileSystemSyncAccessHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileSystemSyncAccessHandle");

bindings::V8SetReturnValue(info, V8FileSystemSyncAccessHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemWritableFileStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FileSystemWritableFileStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FileSystemWritableFileStream");

bindings::V8SetReturnValue(info, V8FileSystemWritableFileStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FontFaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FontFace_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FontFace");

bindings::V8SetReturnValue(info, V8FontFace::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FormDataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_FormData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.FormData");

bindings::V8SetReturnValue(info, V8FormData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPU_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPU");

bindings::V8SetReturnValue(info, V8GPU::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUAdapterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUAdapter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUAdapter");

bindings::V8SetReturnValue(info, V8GPUAdapter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUAdapterInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUAdapterInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUAdapterInfo");

bindings::V8SetReturnValue(info, V8GPUAdapterInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBindGroupExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUBindGroup_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUBindGroup");

bindings::V8SetReturnValue(info, V8GPUBindGroup::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBindGroupLayoutExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUBindGroupLayout_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUBindGroupLayout");

bindings::V8SetReturnValue(info, V8GPUBindGroupLayout::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUBuffer");

bindings::V8SetReturnValue(info, V8GPUBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBufferUsageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUBufferUsage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUBufferUsage");

bindings::V8SetReturnValue(info, V8GPUBufferUsage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUCanvasContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUCanvasContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUCanvasContext");

bindings::V8SetReturnValue(info, V8GPUCanvasContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUColorWriteExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUColorWrite_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUColorWrite");

bindings::V8SetReturnValue(info, V8GPUColorWrite::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUCommandBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUCommandBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUCommandBuffer");

bindings::V8SetReturnValue(info, V8GPUCommandBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUCommandEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUCommandEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUCommandEncoder");

bindings::V8SetReturnValue(info, V8GPUCommandEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUCompilationInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUCompilationInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUCompilationInfo");

bindings::V8SetReturnValue(info, V8GPUCompilationInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUCompilationMessageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUCompilationMessage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUCompilationMessage");

bindings::V8SetReturnValue(info, V8GPUCompilationMessage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUComputePassEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUComputePassEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUComputePassEncoder");

bindings::V8SetReturnValue(info, V8GPUComputePassEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUComputePipelineExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUComputePipeline_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUComputePipeline");

bindings::V8SetReturnValue(info, V8GPUComputePipeline::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUDeviceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUDevice_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUDevice");

bindings::V8SetReturnValue(info, V8GPUDevice::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUDeviceLostInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUDeviceLostInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUDeviceLostInfo");

bindings::V8SetReturnValue(info, V8GPUDeviceLostInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUError");

bindings::V8SetReturnValue(info, V8GPUError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUExternalTextureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUExternalTexture_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUExternalTexture");

bindings::V8SetReturnValue(info, V8GPUExternalTexture::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUHeapPropertyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUHeapProperty_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUHeapProperty");

bindings::V8SetReturnValue(info, V8GPUHeapProperty::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUInternalErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUInternalError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUInternalError");

bindings::V8SetReturnValue(info, V8GPUInternalError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUMapModeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUMapMode_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUMapMode");

bindings::V8SetReturnValue(info, V8GPUMapMode::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUMemoryHeapInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUMemoryHeapInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUMemoryHeapInfo");

bindings::V8SetReturnValue(info, V8GPUMemoryHeapInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUOutOfMemoryErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUOutOfMemoryError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUOutOfMemoryError");

bindings::V8SetReturnValue(info, V8GPUOutOfMemoryError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUPipelineErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUPipelineError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUPipelineError");

bindings::V8SetReturnValue(info, V8GPUPipelineError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUPipelineLayoutExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUPipelineLayout_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUPipelineLayout");

bindings::V8SetReturnValue(info, V8GPUPipelineLayout::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUQuerySetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUQuerySet_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUQuerySet");

bindings::V8SetReturnValue(info, V8GPUQuerySet::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUQueueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUQueue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUQueue");

bindings::V8SetReturnValue(info, V8GPUQueue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderBundleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPURenderBundle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPURenderBundle");

bindings::V8SetReturnValue(info, V8GPURenderBundle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderBundleEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPURenderBundleEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPURenderBundleEncoder");

bindings::V8SetReturnValue(info, V8GPURenderBundleEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderPassEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPURenderPassEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPURenderPassEncoder");

bindings::V8SetReturnValue(info, V8GPURenderPassEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderPipelineExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPURenderPipeline_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPURenderPipeline");

bindings::V8SetReturnValue(info, V8GPURenderPipeline::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUSamplerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUSampler_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUSampler");

bindings::V8SetReturnValue(info, V8GPUSampler::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUShaderModuleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUShaderModule_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUShaderModule");

bindings::V8SetReturnValue(info, V8GPUShaderModule::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUShaderStageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUShaderStage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUShaderStage");

bindings::V8SetReturnValue(info, V8GPUShaderStage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUSubgroupMatrixConfigExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUSubgroupMatrixConfig_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUSubgroupMatrixConfig");

bindings::V8SetReturnValue(info, V8GPUSubgroupMatrixConfig::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUSupportedFeaturesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUSupportedFeatures_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUSupportedFeatures");

bindings::V8SetReturnValue(info, V8GPUSupportedFeatures::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUSupportedLimitsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUSupportedLimits_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUSupportedLimits");

bindings::V8SetReturnValue(info, V8GPUSupportedLimits::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUTextureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUTexture_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUTexture");

bindings::V8SetReturnValue(info, V8GPUTexture::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUTextureUsageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUTextureUsage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUTextureUsage");

bindings::V8SetReturnValue(info, V8GPUTextureUsage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUTextureViewExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUTextureView_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUTextureView");

bindings::V8SetReturnValue(info, V8GPUTextureView::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUUncapturedErrorEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUUncapturedErrorEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUUncapturedErrorEvent");

bindings::V8SetReturnValue(info, V8GPUUncapturedErrorEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUValidationErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_GPUValidationError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.GPUValidationError");

bindings::V8SetReturnValue(info, V8GPUValidationError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_HID_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.HID");

bindings::V8SetReturnValue(info, V8HID::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDConnectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_HIDConnectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.HIDConnectionEvent");

bindings::V8SetReturnValue(info, V8HIDConnectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDDeviceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_HIDDevice_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.HIDDevice");

bindings::V8SetReturnValue(info, V8HIDDevice::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDInputReportEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_HIDInputReportEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.HIDInputReportEvent");

bindings::V8SetReturnValue(info, V8HIDInputReportEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HeadersExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Headers_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Headers");

bindings::V8SetReturnValue(info, V8Headers::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBCursorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBCursor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBCursor");

bindings::V8SetReturnValue(info, V8IDBCursor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBCursorWithValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBCursorWithValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBCursorWithValue");

bindings::V8SetReturnValue(info, V8IDBCursorWithValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBDatabaseExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBDatabase_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBDatabase");

bindings::V8SetReturnValue(info, V8IDBDatabase::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBFactoryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBFactory_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBFactory");

bindings::V8SetReturnValue(info, V8IDBFactory::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBIndexExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBIndex_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBIndex");

bindings::V8SetReturnValue(info, V8IDBIndex::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBKeyRangeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBKeyRange_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBKeyRange");

bindings::V8SetReturnValue(info, V8IDBKeyRange::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBObjectStoreExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBObjectStore_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBObjectStore");

bindings::V8SetReturnValue(info, V8IDBObjectStore::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBOpenDBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBOpenDBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBOpenDBRequest");

bindings::V8SetReturnValue(info, V8IDBOpenDBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBRecordExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBRecord_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBRecord");

bindings::V8SetReturnValue(info, V8IDBRecord::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBRequest");

bindings::V8SetReturnValue(info, V8IDBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBTransactionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBTransaction_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBTransaction");

bindings::V8SetReturnValue(info, V8IDBTransaction::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBVersionChangeEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IDBVersionChangeEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IDBVersionChangeEvent");

bindings::V8SetReturnValue(info, V8IDBVersionChangeEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IdleDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_IdleDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.IdleDetector");

bindings::V8SetReturnValue(info, V8IdleDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageBitmapExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ImageBitmap_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ImageBitmap");

bindings::V8SetReturnValue(info, V8ImageBitmap::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageBitmapRenderingContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ImageBitmapRenderingContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ImageBitmapRenderingContext");

bindings::V8SetReturnValue(info, V8ImageBitmapRenderingContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageDataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ImageData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ImageData");

bindings::V8SetReturnValue(info, V8ImageData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ImageDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ImageDecoder");

bindings::V8SetReturnValue(info, V8ImageDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageTrackExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ImageTrack_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ImageTrack");

bindings::V8SetReturnValue(info, V8ImageTrack::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageTrackListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ImageTrackList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ImageTrackList");

bindings::V8SetReturnValue(info, V8ImageTrackList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LanguageDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_LanguageDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.LanguageDetector");

bindings::V8SetReturnValue(info, V8LanguageDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LanguageModelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_LanguageModel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.LanguageModel");

bindings::V8SetReturnValue(info, V8LanguageModel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LanguageModelParamsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_LanguageModelParams_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.LanguageModelParams");

bindings::V8SetReturnValue(info, V8LanguageModelParams::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LockExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Lock_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Lock");

bindings::V8SetReturnValue(info, V8Lock::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LockManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_LockManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.LockManager");

bindings::V8SetReturnValue(info, V8LockManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ML_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ML");

bindings::V8SetReturnValue(info, V8ML::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MLContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MLContext");

bindings::V8SetReturnValue(info, V8MLContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLGraphExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MLGraph_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MLGraph");

bindings::V8SetReturnValue(info, V8MLGraph::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLGraphBuilderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MLGraphBuilder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MLGraphBuilder");

bindings::V8SetReturnValue(info, V8MLGraphBuilder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLOperandExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MLOperand_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MLOperand");

bindings::V8SetReturnValue(info, V8MLOperand::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLTensorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MLTensor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MLTensor");

bindings::V8SetReturnValue(info, V8MLTensor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MediaCapabilitiesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MediaCapabilities_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MediaCapabilities");

bindings::V8SetReturnValue(info, V8MediaCapabilities::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MediaSourceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MediaSource_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MediaSource");

bindings::V8SetReturnValue(info, V8MediaSource::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MediaSourceHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MediaSourceHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MediaSourceHandle");

bindings::V8SetReturnValue(info, V8MediaSourceHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DIndexBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Mesh2DIndexBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Mesh2DIndexBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DIndexBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DUVBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Mesh2DUVBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Mesh2DUVBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DUVBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DVertexBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Mesh2DVertexBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Mesh2DVertexBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DVertexBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessageChannelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MessageChannel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MessageChannel");

bindings::V8SetReturnValue(info, V8MessageChannel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessageEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MessageEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MessageEvent");

bindings::V8SetReturnValue(info, V8MessageEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessagePortExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MessagePort_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MessagePort");

bindings::V8SetReturnValue(info, V8MessagePort::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Mojo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Mojo");

bindings::V8SetReturnValue(info, V8Mojo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MojoHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MojoHandle");

bindings::V8SetReturnValue(info, V8MojoHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoInterfaceInterceptorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MojoInterfaceInterceptor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MojoInterfaceInterceptor");

bindings::V8SetReturnValue(info, V8MojoInterfaceInterceptor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoInterfaceRequestEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MojoInterfaceRequestEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MojoInterfaceRequestEvent");

bindings::V8SetReturnValue(info, V8MojoInterfaceRequestEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoWatcherExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MojoWatcher_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MojoWatcher");

bindings::V8SetReturnValue(info, V8MojoWatcher::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MulticastControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_MulticastController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.MulticastController");

bindings::V8SetReturnValue(info, V8MulticastController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NavigationPreloadManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_NavigationPreloadManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.NavigationPreloadManager");

bindings::V8SetReturnValue(info, V8NavigationPreloadManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NavigatorUADataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_NavigatorUAData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.NavigatorUAData");

bindings::V8SetReturnValue(info, V8NavigatorUAData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NetworkInformationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_NetworkInformation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.NetworkInformation");

bindings::V8SetReturnValue(info, V8NetworkInformation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NotificationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Notification_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Notification");

bindings::V8SetReturnValue(info, V8Notification::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ObservableExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Observable_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Observable");

bindings::V8SetReturnValue(info, V8Observable::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void OffscreenCanvasExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_OffscreenCanvas_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.OffscreenCanvas");

bindings::V8SetReturnValue(info, V8OffscreenCanvas::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void OffscreenCanvasRenderingContext2DExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_OffscreenCanvasRenderingContext2D_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.OffscreenCanvasRenderingContext2D");

bindings::V8SetReturnValue(info, V8OffscreenCanvasRenderingContext2D::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void OriginExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Origin_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Origin");

bindings::V8SetReturnValue(info, V8Origin::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Path2DExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Path2D_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Path2D");

bindings::V8SetReturnValue(info, V8Path2D::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Performance_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Performance");

bindings::V8SetReturnValue(info, V8Performance::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceEntryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceEntry_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceEntry");

bindings::V8SetReturnValue(info, V8PerformanceEntry::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceMarkExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceMark_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceMark");

bindings::V8SetReturnValue(info, V8PerformanceMark::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceMeasureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceMeasure_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceMeasure");

bindings::V8SetReturnValue(info, V8PerformanceMeasure::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceObserverExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceObserver_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceObserver");

bindings::V8SetReturnValue(info, V8PerformanceObserver::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceObserverEntryListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceObserverEntryList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceObserverEntryList");

bindings::V8SetReturnValue(info, V8PerformanceObserverEntryList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceResourceTimingExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceResourceTiming_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceResourceTiming");

bindings::V8SetReturnValue(info, V8PerformanceResourceTiming::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceServerTimingExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PerformanceServerTiming_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PerformanceServerTiming");

bindings::V8SetReturnValue(info, V8PerformanceServerTiming::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PeriodicSyncManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PeriodicSyncManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PeriodicSyncManager");

bindings::V8SetReturnValue(info, V8PeriodicSyncManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PermissionStatusExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PermissionStatus_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PermissionStatus");

bindings::V8SetReturnValue(info, V8PermissionStatus::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PermissionsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Permissions_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Permissions");

bindings::V8SetReturnValue(info, V8Permissions::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PressureObserverExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PressureObserver_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PressureObserver");

bindings::V8SetReturnValue(info, V8PressureObserver::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PressureRecordExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PressureRecord_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PressureRecord");

bindings::V8SetReturnValue(info, V8PressureRecord::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ProgressEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ProgressEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ProgressEvent");

bindings::V8SetReturnValue(info, V8ProgressEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PromiseRejectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PromiseRejectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PromiseRejectionEvent");

bindings::V8SetReturnValue(info, V8PromiseRejectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ProofreaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Proofreader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Proofreader");

bindings::V8SetReturnValue(info, V8Proofreader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PushManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PushManager");

bindings::V8SetReturnValue(info, V8PushManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushSubscriptionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PushSubscription_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PushSubscription");

bindings::V8SetReturnValue(info, V8PushSubscription::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushSubscriptionOptionsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_PushSubscriptionOptions_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.PushSubscriptionOptions");

bindings::V8SetReturnValue(info, V8PushSubscriptionOptions::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RTCDataChannelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RTCDataChannel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RTCDataChannel");

bindings::V8SetReturnValue(info, V8RTCDataChannel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RTCEncodedAudioFrameExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RTCEncodedAudioFrame_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RTCEncodedAudioFrame");

bindings::V8SetReturnValue(info, V8RTCEncodedAudioFrame::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RTCEncodedVideoFrameExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RTCEncodedVideoFrame_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RTCEncodedVideoFrame");

bindings::V8SetReturnValue(info, V8RTCEncodedVideoFrame::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RTCRtpScriptTransformerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RTCRtpScriptTransformer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RTCRtpScriptTransformer");

bindings::V8SetReturnValue(info, V8RTCRtpScriptTransformer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RTCTransformEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RTCTransformEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RTCTransformEvent");

bindings::V8SetReturnValue(info, V8RTCTransformEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReportBodyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReportBody_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReportBody");

bindings::V8SetReturnValue(info, V8ReportBody::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReportingObserverExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ReportingObserver_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ReportingObserver");

bindings::V8SetReturnValue(info, V8ReportingObserver::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Request_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Request");

bindings::V8SetReturnValue(info, V8Request::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ResponseExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Response_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Response");

bindings::V8SetReturnValue(info, V8Response::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RestrictionTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RestrictionTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RestrictionTarget");

bindings::V8SetReturnValue(info, V8RestrictionTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RewriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Rewriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Rewriter");

bindings::V8SetReturnValue(info, V8Rewriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcReceivedPacketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RtcReceivedPacket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RtcReceivedPacket");

bindings::V8SetReturnValue(info, V8RtcReceivedPacket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcTransportExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RtcTransport_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RtcTransport");

bindings::V8SetReturnValue(info, V8RtcTransport::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcTransportIceCandidateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RtcTransportIceCandidate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RtcTransportIceCandidate");

bindings::V8SetReturnValue(info, V8RtcTransportIceCandidate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcTransportIceEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_RtcTransportIceEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.RtcTransportIceEvent");

bindings::V8SetReturnValue(info, V8RtcTransportIceEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SchedulerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Scheduler_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Scheduler");

bindings::V8SetReturnValue(info, V8Scheduler::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SecurityPolicyViolationEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_SecurityPolicyViolationEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.SecurityPolicyViolationEvent");

bindings::V8SetReturnValue(info, V8SecurityPolicyViolationEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SerialExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Serial_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Serial");

bindings::V8SetReturnValue(info, V8Serial::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SerialPortExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_SerialPort_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.SerialPort");

bindings::V8SetReturnValue(info, V8SerialPort::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ServiceWorkerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ServiceWorker_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ServiceWorker");

bindings::V8SetReturnValue(info, V8ServiceWorker::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ServiceWorkerContainerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ServiceWorkerContainer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ServiceWorkerContainer");

bindings::V8SetReturnValue(info, V8ServiceWorkerContainer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ServiceWorkerRegistrationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_ServiceWorkerRegistration_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.ServiceWorkerRegistration");

bindings::V8SetReturnValue(info, V8ServiceWorkerRegistration::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SourceBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_SourceBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.SourceBuffer");

bindings::V8SetReturnValue(info, V8SourceBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SourceBufferListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_SourceBufferList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.SourceBufferList");

bindings::V8SetReturnValue(info, V8SourceBufferList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StorageBucketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_StorageBucket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.StorageBucket");

bindings::V8SetReturnValue(info, V8StorageBucket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StorageBucketManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_StorageBucketManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.StorageBucketManager");

bindings::V8SetReturnValue(info, V8StorageBucketManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StorageManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_StorageManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.StorageManager");

bindings::V8SetReturnValue(info, V8StorageManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SubscriberExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Subscriber_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Subscriber");

bindings::V8SetReturnValue(info, V8Subscriber::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SubtleCryptoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_SubtleCrypto_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.SubtleCrypto");

bindings::V8SetReturnValue(info, V8SubtleCrypto::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SummarizerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Summarizer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Summarizer");

bindings::V8SetReturnValue(info, V8Summarizer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SyncManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_SyncManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.SyncManager");

bindings::V8SetReturnValue(info, V8SyncManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TCPServerSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TCPServerSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TCPServerSocket");

bindings::V8SetReturnValue(info, V8TCPServerSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TCPSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TCPSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TCPSocket");

bindings::V8SetReturnValue(info, V8TCPSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TaskControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TaskController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TaskController");

bindings::V8SetReturnValue(info, V8TaskController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TaskPriorityChangeEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TaskPriorityChangeEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TaskPriorityChangeEvent");

bindings::V8SetReturnValue(info, V8TaskPriorityChangeEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TaskSignalExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TaskSignal_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TaskSignal");

bindings::V8SetReturnValue(info, V8TaskSignal::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextClusterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextCluster_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextCluster");

bindings::V8SetReturnValue(info, V8TextCluster::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextDecoder");

bindings::V8SetReturnValue(info, V8TextDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextDecoderStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextDecoderStream");

bindings::V8SetReturnValue(info, V8TextDecoderStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextDetector");

bindings::V8SetReturnValue(info, V8TextDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextEncoder");

bindings::V8SetReturnValue(info, V8TextEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextEncoderStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextEncoderStream");

bindings::V8SetReturnValue(info, V8TextEncoderStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextMetricsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TextMetrics_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TextMetrics");

bindings::V8SetReturnValue(info, V8TextMetrics::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TimestampTriggerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TimestampTrigger_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TimestampTrigger");

bindings::V8SetReturnValue(info, V8TimestampTrigger::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TranslatorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Translator_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Translator");

bindings::V8SetReturnValue(info, V8Translator::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedHTMLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TrustedHTML_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TrustedHTML");

bindings::V8SetReturnValue(info, V8TrustedHTML::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedScriptExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TrustedScript_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TrustedScript");

bindings::V8SetReturnValue(info, V8TrustedScript::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedScriptURLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TrustedScriptURL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TrustedScriptURL");

bindings::V8SetReturnValue(info, V8TrustedScriptURL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedTypePolicyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TrustedTypePolicy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TrustedTypePolicy");

bindings::V8SetReturnValue(info, V8TrustedTypePolicy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedTypePolicyFactoryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_TrustedTypePolicyFactory_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.TrustedTypePolicyFactory");

bindings::V8SetReturnValue(info, V8TrustedTypePolicyFactory::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void UDPSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_UDPSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.UDPSocket");

bindings::V8SetReturnValue(info, V8UDPSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_URL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.URL");

bindings::V8SetReturnValue(info, V8URL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLPatternExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_URLPattern_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.URLPattern");

bindings::V8SetReturnValue(info, V8URLPattern::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLSearchParamsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_URLSearchParams_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.URLSearchParams");

bindings::V8SetReturnValue(info, V8URLSearchParams::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USB_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USB");

bindings::V8SetReturnValue(info, V8USB::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBAlternateInterfaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBAlternateInterface_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBAlternateInterface");

bindings::V8SetReturnValue(info, V8USBAlternateInterface::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBConfigurationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBConfiguration_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBConfiguration");

bindings::V8SetReturnValue(info, V8USBConfiguration::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBConnectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBConnectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBConnectionEvent");

bindings::V8SetReturnValue(info, V8USBConnectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBDeviceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBDevice_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBDevice");

bindings::V8SetReturnValue(info, V8USBDevice::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBEndpointExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBEndpoint_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBEndpoint");

bindings::V8SetReturnValue(info, V8USBEndpoint::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBInTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBInTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBInTransferResult");

bindings::V8SetReturnValue(info, V8USBInTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBInterfaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBInterface_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBInterface");

bindings::V8SetReturnValue(info, V8USBInterface::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousInTransferPacketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBIsochronousInTransferPacket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBIsochronousInTransferPacket");

bindings::V8SetReturnValue(info, V8USBIsochronousInTransferPacket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousInTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBIsochronousInTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBIsochronousInTransferResult");

bindings::V8SetReturnValue(info, V8USBIsochronousInTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousOutTransferPacketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBIsochronousOutTransferPacket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBIsochronousOutTransferPacket");

bindings::V8SetReturnValue(info, V8USBIsochronousOutTransferPacket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousOutTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBIsochronousOutTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBIsochronousOutTransferResult");

bindings::V8SetReturnValue(info, V8USBIsochronousOutTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBOutTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_USBOutTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.USBOutTransferResult");

bindings::V8SetReturnValue(info, V8USBOutTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void UserActivationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_UserActivation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.UserActivation");

bindings::V8SetReturnValue(info, V8UserActivation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void VideoColorSpaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_VideoColorSpace_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.VideoColorSpace");

bindings::V8SetReturnValue(info, V8VideoColorSpace::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void VideoDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_VideoDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.VideoDecoder");

bindings::V8SetReturnValue(info, V8VideoDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void VideoEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_VideoEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.VideoEncoder");

bindings::V8SetReturnValue(info, V8VideoEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void VideoEncoderBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_VideoEncoderBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.VideoEncoderBuffer");

bindings::V8SetReturnValue(info, V8VideoEncoderBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void VideoFrameExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_VideoFrame_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.VideoFrame");

bindings::V8SetReturnValue(info, V8VideoFrame::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WGSLLanguageFeaturesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WGSLLanguageFeatures_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WGSLLanguageFeatures");

bindings::V8SetReturnValue(info, V8WGSLLanguageFeatures::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WakeLockExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WakeLock_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WakeLock");

bindings::V8SetReturnValue(info, V8WakeLock::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WakeLockSentinelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WakeLockSentinel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WakeLockSentinel");

bindings::V8SetReturnValue(info, V8WakeLockSentinel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGL2RenderingContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGL2RenderingContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGL2RenderingContext");

bindings::V8SetReturnValue(info, V8WebGL2RenderingContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGL2RenderingContextWebGPUExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGL2RenderingContextWebGPU_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGL2RenderingContextWebGPU");

bindings::V8SetReturnValue(info, V8WebGL2RenderingContextWebGPU::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLActiveInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLActiveInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLActiveInfo");

bindings::V8SetReturnValue(info, V8WebGLActiveInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLBuffer");

bindings::V8SetReturnValue(info, V8WebGLBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLContextEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLContextEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLContextEvent");

bindings::V8SetReturnValue(info, V8WebGLContextEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLFramebufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLFramebuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLFramebuffer");

bindings::V8SetReturnValue(info, V8WebGLFramebuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLObjectExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLObject_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLObject");

bindings::V8SetReturnValue(info, V8WebGLObject::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLProgramExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLProgram_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLProgram");

bindings::V8SetReturnValue(info, V8WebGLProgram::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLQueryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLQuery_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLQuery");

bindings::V8SetReturnValue(info, V8WebGLQuery::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLRenderbufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLRenderbuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLRenderbuffer");

bindings::V8SetReturnValue(info, V8WebGLRenderbuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLRenderingContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLRenderingContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLRenderingContext");

bindings::V8SetReturnValue(info, V8WebGLRenderingContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLRenderingContextWebGPUExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLRenderingContextWebGPU_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLRenderingContextWebGPU");

bindings::V8SetReturnValue(info, V8WebGLRenderingContextWebGPU::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLSamplerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLSampler_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLSampler");

bindings::V8SetReturnValue(info, V8WebGLSampler::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLShaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLShader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLShader");

bindings::V8SetReturnValue(info, V8WebGLShader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLShaderPrecisionFormatExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLShaderPrecisionFormat_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLShaderPrecisionFormat");

bindings::V8SetReturnValue(info, V8WebGLShaderPrecisionFormat::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLSyncExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLSync_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLSync");

bindings::V8SetReturnValue(info, V8WebGLSync::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLTextureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLTexture_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLTexture");

bindings::V8SetReturnValue(info, V8WebGLTexture::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLTransformFeedbackExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLTransformFeedback_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLTransformFeedback");

bindings::V8SetReturnValue(info, V8WebGLTransformFeedback::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLUniformLocationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLUniformLocation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLUniformLocation");

bindings::V8SetReturnValue(info, V8WebGLUniformLocation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLVertexArrayObjectExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebGLVertexArrayObject_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebGLVertexArrayObject");

bindings::V8SetReturnValue(info, V8WebGLVertexArrayObject::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebPrintingManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebPrintingManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebPrintingManager");

bindings::V8SetReturnValue(info, V8WebPrintingManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebSocket");

bindings::V8SetReturnValue(info, V8WebSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebSocketErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebSocketError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebSocketError");

bindings::V8SetReturnValue(info, V8WebSocketError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebSocketStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebSocketStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebSocketStream");

bindings::V8SetReturnValue(info, V8WebSocketStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebTransport_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebTransport");

bindings::V8SetReturnValue(info, V8WebTransport::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportBidirectionalStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebTransportBidirectionalStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebTransportBidirectionalStream");

bindings::V8SetReturnValue(info, V8WebTransportBidirectionalStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportDatagramDuplexStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebTransportDatagramDuplexStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebTransportDatagramDuplexStream");

bindings::V8SetReturnValue(info, V8WebTransportDatagramDuplexStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WebTransportError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WebTransportError");

bindings::V8SetReturnValue(info, V8WebTransportError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Worker_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Worker");

bindings::V8SetReturnValue(info, V8Worker::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WorkerGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WorkerGlobalScope");

bindings::V8SetReturnValue(info, V8WorkerGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerLocationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WorkerLocation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WorkerLocation");

bindings::V8SetReturnValue(info, V8WorkerLocation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerNavigatorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WorkerNavigator_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WorkerNavigator");

bindings::V8SetReturnValue(info, V8WorkerNavigator::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_Writer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.Writer");

bindings::V8SetReturnValue(info, V8Writer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void XMLHttpRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_XMLHttpRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.XMLHttpRequest");

bindings::V8SetReturnValue(info, V8XMLHttpRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void XMLHttpRequestEventTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_XMLHttpRequestEventTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.XMLHttpRequestEventTarget");

bindings::V8SetReturnValue(info, V8XMLHttpRequestEventTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void XMLHttpRequestUploadExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_XMLHttpRequestUpload_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.XMLHttpRequestUpload");

bindings::V8SetReturnValue(info, V8XMLHttpRequestUpload::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CancelAnimationFrameOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_cancelAnimationFrame");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.cancelAnimationFrame");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_handle = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->cancelAnimationFrame(arg1_handle);

}

void CloseOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_close");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.close");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->close();

}

void PostMessageOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_message = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transfer = NativeValueTraits<IDLSequence<IDLObject>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->postMessage(script_state, arg1_message, std::move(arg2_transfer), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void PostMessageOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_message = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<PostMessageOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_options;
if (info[1]->IsUndefined()) {
  arg2_options = PostMessageOptions::Create();
} else {
  arg2_options = NativeValueTraits<PostMessageOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->postMessage(script_state, arg1_message, arg2_options, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void PostMessageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_postMessage");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.postMessage");


const int arg_count = std::min(info.Length(), 2);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 2) {
  if (info[1]->IsUndefined()) {
  return PostMessageOperationOverload2(info);
}
if (info[1]->IsNullOrUndefined()) {
  return PostMessageOperationOverload2(info);
}
if (info[1]->IsObject()) {
  ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return PostMessageOperationOverload1(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return PostMessageOperationOverload2(info);
}
break;
}
if (arg_count == 1) {
  return PostMessageOperationOverload2(info);
}
} while (false);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void RequestAnimationFrameOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_requestAnimationFrame");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.requestAnimationFrame");


v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kRequestAnimationFrameWorkers);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_callback = NativeValueTraits<V8FrameRequestCallback>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->requestAnimationFrame(arg1_callback, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void WebkitRequestFileSystemOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_webkitRequestFileSystem");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.webkitRequestFileSystem");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kRequestFileSystemWorker);

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLUnsignedShort>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLNullable<V8FileSystemCallback>>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_success_callback{nullptr};
if (!info[2]->IsUndefined()) {
  arg3_success_callback = NativeValueTraits<IDLNullable<V8FileSystemCallback>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLNullable<V8ErrorCallback>>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_error_callback{nullptr};
if (!info[3]->IsUndefined()) {
  arg4_error_callback = NativeValueTraits<IDLNullable<V8ErrorCallback>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
WorkerGlobalScopeFileSystem::webkitRequestFileSystem(*blink_receiver, arg1_type, arg2_size, arg3_success_callback, arg4_error_callback);

}

void WebkitRequestFileSystemSyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_webkitRequestFileSystemSync");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.webkitRequestFileSystemSync");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kRequestFileSystemSyncWorker);

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLUnsignedShort>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = WorkerGlobalScopeFileSystem::webkitRequestFileSystemSync(*blink_receiver, arg1_type, arg2_size, exception_state);
static_assert(bindings::IsReturnTypeCompatible<DOMFileSystemSync, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void WebkitResolveLocalFileSystemSyncURLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_webkitResolveLocalFileSystemSyncURL");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.webkitResolveLocalFileSystemSyncURL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_url = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = WorkerGlobalScopeFileSystem::webkitResolveLocalFileSystemSyncURL(*blink_receiver, arg1_url, exception_state);
static_assert(bindings::IsReturnTypeCompatible<EntrySync, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void WebkitResolveLocalFileSystemURLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DedicatedWorkerGlobalScope_webkitResolveLocalFileSystemURL");
BLINK_BINDINGS_TRACE_EVENT("DedicatedWorkerGlobalScope.webkitResolveLocalFileSystemURL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DedicatedWorkerGlobalScope* blink_receiver = V8DedicatedWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_url = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_success_callback = NativeValueTraits<V8EntryCallback>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLNullable<V8ErrorCallback>>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_error_callback{nullptr};
if (!info[2]->IsUndefined()) {
  arg3_error_callback = NativeValueTraits<IDLNullable<V8ErrorCallback>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
WorkerGlobalScopeFileSystem::webkitResolveLocalFileSystemURL(*blink_receiver, arg1_url, arg2_success_callback, arg3_error_callback);

}


}  // namespace v8_dedicated_worker_global_scope

using namespace v8_dedicated_worker_global_scope;

}  // namespace 

void V8DedicatedWorkerGlobalScope::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8DedicatedWorkerGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8DedicatedWorkerGlobalScope::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"name", NameAttributeGetCallback, NameAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onmessage", OnmessageAttributeGetCallback, OnmessageAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onmessageerror", OnmessageerrorAttributeGetCallback, OnmessageerrorAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "DedicatedWorkerGlobalScope", kAttributeTable);
}



{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"TEMPORARY", V8DedicatedWorkerGlobalScope::Constant::kTemporary},
{"PERSISTENT", V8DedicatedWorkerGlobalScope::Constant::kPersistent},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}


{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"AbortController", AbortControllerExposedConstructCallback}, 
{"AbortSignal", AbortSignalExposedConstructCallback}, 
{"AudioData", AudioDataExposedConstructCallback}, 
{"Blob", BlobExposedConstructCallback}, 
{"BroadcastChannel", BroadcastChannelExposedConstructCallback}, 
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CSSSkewX", CSSSkewXExposedConstructCallback}, 
{"CSSSkewY", CSSSkewYExposedConstructCallback}, 
{"CanvasGradient", CanvasGradientExposedConstructCallback}, 
{"CanvasPattern", CanvasPatternExposedConstructCallback}, 
{"CloseEvent", CloseEventExposedConstructCallback}, 
{"CompressionStream", CompressionStreamExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"Crypto", CryptoExposedConstructCallback}, 
{"CustomEvent", CustomEventExposedConstructCallback}, 
{"DOMException", DOMExceptionExposedConstructCallback}, 
{"DOMMatrix", DOMMatrixExposedConstructCallback}, 
{"DOMMatrixReadOnly", DOMMatrixReadOnlyExposedConstructCallback}, 
{"DOMPoint", DOMPointExposedConstructCallback}, 
{"DOMPointReadOnly", DOMPointReadOnlyExposedConstructCallback}, 
{"DOMQuad", DOMQuadExposedConstructCallback}, 
{"DOMRect", DOMRectExposedConstructCallback}, 
{"DOMRectReadOnly", DOMRectReadOnlyExposedConstructCallback}, 
{"DOMStringList", DOMStringListExposedConstructCallback}, 
{"DecompressionStream", DecompressionStreamExposedConstructCallback}, 
{"DedicatedWorkerGlobalScope", DedicatedWorkerGlobalScopeExposedConstructCallback}, 
{"EncodedAudioChunk", EncodedAudioChunkExposedConstructCallback}, 
{"EncodedVideoChunk", EncodedVideoChunkExposedConstructCallback}, 
{"ErrorEvent", ErrorEventExposedConstructCallback}, 
{"Event", EventExposedConstructCallback}, 
{"EventSource", EventSourceExposedConstructCallback}, 
{"EventTarget", EventTargetExposedConstructCallback}, 
{"File", FileExposedConstructCallback}, 
{"FileList", FileListExposedConstructCallback}, 
{"FileReader", FileReaderExposedConstructCallback}, 
{"FileReaderSync", FileReaderSyncExposedConstructCallback}, 
{"FontFace", FontFaceExposedConstructCallback}, 
{"FormData", FormDataExposedConstructCallback}, 
{"Headers", HeadersExposedConstructCallback}, 
{"IDBCursor", IDBCursorExposedConstructCallback}, 
{"IDBCursorWithValue", IDBCursorWithValueExposedConstructCallback}, 
{"IDBDatabase", IDBDatabaseExposedConstructCallback}, 
{"IDBFactory", IDBFactoryExposedConstructCallback}, 
{"IDBIndex", IDBIndexExposedConstructCallback}, 
{"IDBKeyRange", IDBKeyRangeExposedConstructCallback}, 
{"IDBObjectStore", IDBObjectStoreExposedConstructCallback}, 
{"IDBOpenDBRequest", IDBOpenDBRequestExposedConstructCallback}, 
{"IDBRequest", IDBRequestExposedConstructCallback}, 
{"IDBTransaction", IDBTransactionExposedConstructCallback}, 
{"IDBVersionChangeEvent", IDBVersionChangeEventExposedConstructCallback}, 
{"ImageBitmap", ImageBitmapExposedConstructCallback}, 
{"ImageBitmapRenderingContext", ImageBitmapRenderingContextExposedConstructCallback}, 
{"ImageData", ImageDataExposedConstructCallback}, 
{"MediaCapabilities", MediaCapabilitiesExposedConstructCallback}, 
{"MediaSource", MediaSourceExposedConstructCallback}, 
{"MediaSourceHandle", MediaSourceHandleExposedConstructCallback}, 
{"MessageChannel", MessageChannelExposedConstructCallback}, 
{"MessageEvent", MessageEventExposedConstructCallback}, 
{"MessagePort", MessagePortExposedConstructCallback}, 
{"NavigatorUAData", NavigatorUADataExposedConstructCallback}, 
{"NetworkInformation", NetworkInformationExposedConstructCallback}, 
{"Observable", ObservableExposedConstructCallback}, 
{"OffscreenCanvas", OffscreenCanvasExposedConstructCallback}, 
{"OffscreenCanvasRenderingContext2D", OffscreenCanvasRenderingContext2DExposedConstructCallback}, 
{"Path2D", Path2DExposedConstructCallback}, 
{"Performance", PerformanceExposedConstructCallback}, 
{"PerformanceEntry", PerformanceEntryExposedConstructCallback}, 
{"PerformanceMark", PerformanceMarkExposedConstructCallback}, 
{"PerformanceMeasure", PerformanceMeasureExposedConstructCallback}, 
{"PerformanceObserver", PerformanceObserverExposedConstructCallback}, 
{"PerformanceObserverEntryList", PerformanceObserverEntryListExposedConstructCallback}, 
{"PerformanceResourceTiming", PerformanceResourceTimingExposedConstructCallback}, 
{"PerformanceServerTiming", PerformanceServerTimingExposedConstructCallback}, 
{"ProgressEvent", ProgressEventExposedConstructCallback}, 
{"PromiseRejectionEvent", PromiseRejectionEventExposedConstructCallback}, 
{"RTCEncodedAudioFrame", RTCEncodedAudioFrameExposedConstructCallback}, 
{"RTCEncodedVideoFrame", RTCEncodedVideoFrameExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"ReportBody", ReportBodyExposedConstructCallback}, 
{"ReportingObserver", ReportingObserverExposedConstructCallback}, 
{"Request", RequestExposedConstructCallback}, 
{"Response", ResponseExposedConstructCallback}, 
{"Scheduler", SchedulerExposedConstructCallback}, 
{"SecurityPolicyViolationEvent", SecurityPolicyViolationEventExposedConstructCallback}, 
{"SourceBuffer", SourceBufferExposedConstructCallback}, 
{"SourceBufferList", SourceBufferListExposedConstructCallback}, 
{"Subscriber", SubscriberExposedConstructCallback}, 
{"SyncManager", SyncManagerExposedConstructCallback}, 
{"TaskController", TaskControllerExposedConstructCallback}, 
{"TaskPriorityChangeEvent", TaskPriorityChangeEventExposedConstructCallback}, 
{"TaskSignal", TaskSignalExposedConstructCallback}, 
{"TextDecoder", TextDecoderExposedConstructCallback}, 
{"TextDecoderStream", TextDecoderStreamExposedConstructCallback}, 
{"TextEncoder", TextEncoderExposedConstructCallback}, 
{"TextEncoderStream", TextEncoderStreamExposedConstructCallback}, 
{"TextMetrics", TextMetricsExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"TrustedHTML", TrustedHTMLExposedConstructCallback}, 
{"TrustedScript", TrustedScriptExposedConstructCallback}, 
{"TrustedScriptURL", TrustedScriptURLExposedConstructCallback}, 
{"TrustedTypePolicy", TrustedTypePolicyExposedConstructCallback}, 
{"TrustedTypePolicyFactory", TrustedTypePolicyFactoryExposedConstructCallback}, 
{"URL", URLExposedConstructCallback}, 
{"URLPattern", URLPatternExposedConstructCallback}, 
{"URLSearchParams", URLSearchParamsExposedConstructCallback}, 
{"UserActivation", UserActivationExposedConstructCallback}, 
{"VideoColorSpace", VideoColorSpaceExposedConstructCallback}, 
{"VideoFrame", VideoFrameExposedConstructCallback}, 
{"WebGL2RenderingContext", WebGL2RenderingContextExposedConstructCallback}, 
{"WebGLActiveInfo", WebGLActiveInfoExposedConstructCallback}, 
{"WebGLBuffer", WebGLBufferExposedConstructCallback}, 
{"WebGLContextEvent", WebGLContextEventExposedConstructCallback}, 
{"WebGLFramebuffer", WebGLFramebufferExposedConstructCallback}, 
{"WebGLObject", WebGLObjectExposedConstructCallback}, 
{"WebGLProgram", WebGLProgramExposedConstructCallback}, 
{"WebGLQuery", WebGLQueryExposedConstructCallback}, 
{"WebGLRenderbuffer", WebGLRenderbufferExposedConstructCallback}, 
{"WebGLRenderingContext", WebGLRenderingContextExposedConstructCallback}, 
{"WebGLSampler", WebGLSamplerExposedConstructCallback}, 
{"WebGLShader", WebGLShaderExposedConstructCallback}, 
{"WebGLShaderPrecisionFormat", WebGLShaderPrecisionFormatExposedConstructCallback}, 
{"WebGLSync", WebGLSyncExposedConstructCallback}, 
{"WebGLTexture", WebGLTextureExposedConstructCallback}, 
{"WebGLTransformFeedback", WebGLTransformFeedbackExposedConstructCallback}, 
{"WebGLUniformLocation", WebGLUniformLocationExposedConstructCallback}, 
{"WebGLVertexArrayObject", WebGLVertexArrayObjectExposedConstructCallback}, 
{"WebSocket", WebSocketExposedConstructCallback}, 
{"Worker", WorkerExposedConstructCallback}, 
{"WorkerGlobalScope", WorkerGlobalScopeExposedConstructCallback}, 
{"WorkerLocation", WorkerLocationExposedConstructCallback}, 
{"WorkerNavigator", WorkerNavigatorExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
{"XMLHttpRequest", XMLHttpRequestExposedConstructCallback}, 
{"XMLHttpRequestEventTarget", XMLHttpRequestEventTargetExposedConstructCallback}, 
{"XMLHttpRequestUpload", XMLHttpRequestUploadExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"cancelAnimationFrame", CancelAnimationFrameOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"close", CloseOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"postMessage", PostMessageOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"requestAnimationFrame", RequestAnimationFrameOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "DedicatedWorkerGlobalScope", kOperationTable);
}



}

void V8DedicatedWorkerGlobalScope::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::RTCRtpScriptTransformEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onrtctransform", OnrtctransformAttributeGetCallback, OnrtctransformAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "DedicatedWorkerGlobalScope", kAttributeTable);
}



if (RuntimeEnabledFeatures::BackgroundFetchEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"BackgroundFetchManager", BackgroundFetchManagerExposedConstructCallback}, 
{"BackgroundFetchRecord", BackgroundFetchRecordExposedConstructCallback}, 
{"BackgroundFetchRegistration", BackgroundFetchRegistrationExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::Canvas2dCanvasFilterEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CanvasFilter", CanvasFilterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::ContentIndexEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ContentIndex", ContentIndexExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::RegionCaptureEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CropTarget", CropTargetExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::IndexedDbGetAllRecordsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"IDBRecord", IDBRecordExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::MachineLearningNeuralNetworkEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ML", MLExposedConstructCallback}, 
{"MLGraph", MLGraphExposedConstructCallback}, 
{"MLGraphBuilder", MLGraphBuilderExposedConstructCallback}, 
{"MLOperand", MLOperandExposedConstructCallback}, 
{"MLTensor", MLTensorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::MojoJSTestEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"MojoInterfaceInterceptor", MojoInterfaceInterceptorExposedConstructCallback}, 
{"MojoInterfaceRequestEvent", MojoInterfaceRequestEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::NotificationsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Notification", NotificationExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::OriginAPIEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Origin", OriginExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PeriodicBackgroundSyncEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PeriodicSyncManager", PeriodicSyncManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PermissionsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PermissionStatus", PermissionStatusExposedConstructCallback}, 
{"Permissions", PermissionsExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PushMessagingEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PushManager", PushManagerExposedConstructCallback}, 
{"PushSubscription", PushSubscriptionExposedConstructCallback}, 
{"PushSubscriptionOptions", PushSubscriptionOptionsExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::TransferableRTCDataChannelEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RTCDataChannel", RTCDataChannelExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::RTCRtpScriptTransformEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RTCRtpScriptTransformer", RTCRtpScriptTransformerExposedConstructCallback}, 
{"RTCTransformEvent", RTCTransformEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::ElementCaptureEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RestrictionTarget", RestrictionTargetExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::RTCRtpTransportEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RtcReceivedPacket", RtcReceivedPacketExposedConstructCallback}, 
{"RtcTransportIceCandidate", RtcTransportIceCandidateExposedConstructCallback}, 
{"RtcTransportIceEvent", RtcTransportIceEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::WebGLOnWebGPUEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WebGL2RenderingContextWebGPU", WebGL2RenderingContextWebGPUExposedConstructCallback}, 
{"WebGLRenderingContextWebGPU", WebGLRenderingContextWebGPUExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::WebSocketStreamEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WebSocketError", WebSocketErrorExposedConstructCallback}, 
{"WebSocketStream", WebSocketStreamExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}

if (RuntimeEnabledFeatures::FileSystemEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"webkitRequestFileSystem", WebkitRequestFileSystemOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"webkitRequestFileSystemSync", WebkitRequestFileSystemSyncOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"webkitResolveLocalFileSystemSyncURL", WebkitResolveLocalFileSystemSyncURLOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"webkitResolveLocalFileSystemURL", WebkitResolveLocalFileSystemURLOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "DedicatedWorkerGlobalScope", kOperationTable);
}


}

void V8DedicatedWorkerGlobalScope::Impl::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (instance_object.IsEmpty()) {
  instance_object = context->Global();
}




v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
const bool is_in_secure_context = execution_context->IsSecureContext();
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (is_in_secure_context && feature_selector.IsAll()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"AudioDecoder", AudioDecoderExposedConstructCallback}, 
{"AudioEncoder", AudioEncoderExposedConstructCallback}, 
{"Cache", CacheExposedConstructCallback}, 
{"CacheStorage", CacheStorageExposedConstructCallback}, 
{"CreateMonitor", CreateMonitorExposedConstructCallback}, 
{"CryptoKey", CryptoKeyExposedConstructCallback}, 
{"FileSystemSyncAccessHandle", FileSystemSyncAccessHandleExposedConstructCallback}, 
{"GPU", GPUExposedConstructCallback}, 
{"GPUAdapter", GPUAdapterExposedConstructCallback}, 
{"GPUAdapterInfo", GPUAdapterInfoExposedConstructCallback}, 
{"GPUBindGroup", GPUBindGroupExposedConstructCallback}, 
{"GPUBindGroupLayout", GPUBindGroupLayoutExposedConstructCallback}, 
{"GPUBuffer", GPUBufferExposedConstructCallback}, 
{"GPUBufferUsage", GPUBufferUsageExposedConstructCallback}, 
{"GPUCanvasContext", GPUCanvasContextExposedConstructCallback}, 
{"GPUColorWrite", GPUColorWriteExposedConstructCallback}, 
{"GPUCommandBuffer", GPUCommandBufferExposedConstructCallback}, 
{"GPUCommandEncoder", GPUCommandEncoderExposedConstructCallback}, 
{"GPUCompilationInfo", GPUCompilationInfoExposedConstructCallback}, 
{"GPUCompilationMessage", GPUCompilationMessageExposedConstructCallback}, 
{"GPUComputePassEncoder", GPUComputePassEncoderExposedConstructCallback}, 
{"GPUComputePipeline", GPUComputePipelineExposedConstructCallback}, 
{"GPUDevice", GPUDeviceExposedConstructCallback}, 
{"GPUDeviceLostInfo", GPUDeviceLostInfoExposedConstructCallback}, 
{"GPUError", GPUErrorExposedConstructCallback}, 
{"GPUExternalTexture", GPUExternalTextureExposedConstructCallback}, 
{"GPUInternalError", GPUInternalErrorExposedConstructCallback}, 
{"GPUMapMode", GPUMapModeExposedConstructCallback}, 
{"GPUOutOfMemoryError", GPUOutOfMemoryErrorExposedConstructCallback}, 
{"GPUPipelineError", GPUPipelineErrorExposedConstructCallback}, 
{"GPUPipelineLayout", GPUPipelineLayoutExposedConstructCallback}, 
{"GPUQuerySet", GPUQuerySetExposedConstructCallback}, 
{"GPUQueue", GPUQueueExposedConstructCallback}, 
{"GPURenderBundle", GPURenderBundleExposedConstructCallback}, 
{"GPURenderBundleEncoder", GPURenderBundleEncoderExposedConstructCallback}, 
{"GPURenderPassEncoder", GPURenderPassEncoderExposedConstructCallback}, 
{"GPURenderPipeline", GPURenderPipelineExposedConstructCallback}, 
{"GPUSampler", GPUSamplerExposedConstructCallback}, 
{"GPUShaderModule", GPUShaderModuleExposedConstructCallback}, 
{"GPUShaderStage", GPUShaderStageExposedConstructCallback}, 
{"GPUSupportedFeatures", GPUSupportedFeaturesExposedConstructCallback}, 
{"GPUSupportedLimits", GPUSupportedLimitsExposedConstructCallback}, 
{"GPUTexture", GPUTextureExposedConstructCallback}, 
{"GPUTextureUsage", GPUTextureUsageExposedConstructCallback}, 
{"GPUTextureView", GPUTextureViewExposedConstructCallback}, 
{"GPUUncapturedErrorEvent", GPUUncapturedErrorEventExposedConstructCallback}, 
{"GPUValidationError", GPUValidationErrorExposedConstructCallback}, 
{"IdleDetector", IdleDetectorExposedConstructCallback}, 
{"ImageDecoder", ImageDecoderExposedConstructCallback}, 
{"ImageTrack", ImageTrackExposedConstructCallback}, 
{"ImageTrackList", ImageTrackListExposedConstructCallback}, 
{"NavigationPreloadManager", NavigationPreloadManagerExposedConstructCallback}, 
{"ServiceWorkerRegistration", ServiceWorkerRegistrationExposedConstructCallback}, 
{"StorageManager", StorageManagerExposedConstructCallback}, 
{"SubtleCrypto", SubtleCryptoExposedConstructCallback}, 
{"VideoDecoder", VideoDecoderExposedConstructCallback}, 
{"VideoEncoder", VideoEncoderExposedConstructCallback}, 
{"WGSLLanguageFeatures", WGSLLanguageFeaturesExposedConstructCallback}, 
{"WebTransport", WebTransportExposedConstructCallback}, 
{"WebTransportBidirectionalStream", WebTransportBidirectionalStreamExposedConstructCallback}, 
{"WebTransportDatagramDuplexStream", WebTransportDatagramDuplexStreamExposedConstructCallback}, 
{"WebTransportError", WebTransportErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::BarcodeDetectorEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"BarcodeDetector", BarcodeDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::FaceDetectorEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"FaceDetector", FaceDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::FileSystemAccessEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"FileSystemDirectoryHandle", FileSystemDirectoryHandleExposedConstructCallback}, 
{"FileSystemFileHandle", FileSystemFileHandleExposedConstructCallback}, 
{"FileSystemHandle", FileSystemHandleExposedConstructCallback}, 
{"FileSystemWritableFileStream", FileSystemWritableFileStreamExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::FileSystemObserverEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"FileSystemObserver", FileSystemObserverExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebGPUDeveloperFeaturesEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"GPUHeapProperty", GPUHeapPropertyExposedConstructCallback}, 
{"GPUMemoryHeapInfo", GPUMemoryHeapInfoExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"GPUSubgroupMatrixConfig", GPUSubgroupMatrixConfigExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebHIDEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"HID", HIDExposedConstructCallback}, 
{"HIDConnectionEvent", HIDConnectionEventExposedConstructCallback}, 
{"HIDDevice", HIDDeviceExposedConstructCallback}, 
{"HIDInputReportEvent", HIDInputReportEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::LanguageDetectionAPIForWorkersEnabled() && RuntimeEnabledFeatures::LanguageDetectionAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kLanguageDetectionAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"LanguageDetector", LanguageDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIPromptAPIForWorkersEnabled() && RuntimeEnabledFeatures::AIPromptAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIPromptAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"LanguageModel", LanguageModelExposedConstructCallback}, 
{"LanguageModelParams", LanguageModelParamsExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::StableBlinkFeaturesEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Lock", LockExposedConstructCallback}, 
{"LockManager", LockManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::MachineLearningNeuralNetworkEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"MLContext", MLContextExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::Canvas2dMeshEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kCanvas2dMesh)) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Mesh2DIndexBuffer", Mesh2DIndexBufferExposedConstructCallback}, 
{"Mesh2DUVBuffer", Mesh2DUVBufferExposedConstructCallback}, 
{"Mesh2DVertexBuffer", Mesh2DVertexBufferExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
const ContextFeatureSettings* context_feature_settings = ContextFeatureSettings::From(execution_context, ContextFeatureSettings::CreationMode::kDontCreateIfNotExists);
if (feature_selector.IsAll() && (RuntimeEnabledFeatures::MojoJSEnabled() || (context_feature_settings && context_feature_settings->isMojoJSEnabled()))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Mojo", MojoExposedConstructCallback}, 
{"MojoHandle", MojoHandleExposedConstructCallback}, 
{"MojoWatcher", MojoWatcherExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
const bool is_in_isolated_context = execution_context->IsIsolatedContext();
if (is_in_isolated_context && is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::MulticastInDirectSocketsEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"MulticastController", MulticastControllerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::ComputePressureEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PressureObserver", PressureObserverExposedConstructCallback}, 
{"PressureRecord", PressureRecordExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIProofreadingAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIProofreadingAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Proofreader", ProofreaderExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIRewriterAPIForWorkersEnabled() && RuntimeEnabledFeatures::AIRewriterAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIRewriterAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Rewriter", RewriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::RTCRtpTransportEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RtcTransport", RtcTransportExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::SerialEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Serial", SerialExposedConstructCallback}, 
{"SerialPort", SerialPortExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::ServiceWorkerInDedicatedWorkerEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ServiceWorker", ServiceWorkerExposedConstructCallback}, 
{"ServiceWorkerContainer", ServiceWorkerContainerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::StorageBucketsEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"StorageBucket", StorageBucketExposedConstructCallback}, 
{"StorageBucketManager", StorageBucketManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::AISummarizationAPIForWorkersEnabled() && RuntimeEnabledFeatures::AISummarizationAPIEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Summarizer", SummarizerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_isolated_context && is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::DirectSocketsEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TCPServerSocket", TCPServerSocketExposedConstructCallback}, 
{"TCPSocket", TCPSocketExposedConstructCallback}, 
{"UDPSocket", UDPSocketExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::ExtendedTextMetricsEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kExtendedTextMetrics)) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TextCluster", TextClusterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::TextDetectorEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TextDetector", TextDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::NotificationTriggersEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kNotificationTriggers)) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TimestampTrigger", TimestampTriggerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::TranslationAPIForWorkersEnabled() && RuntimeEnabledFeatures::TranslationAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kTranslationAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Translator", TranslatorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebUSBOnDedicatedWorkersEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"USB", USBExposedConstructCallback}, 
{"USBAlternateInterface", USBAlternateInterfaceExposedConstructCallback}, 
{"USBConfiguration", USBConfigurationExposedConstructCallback}, 
{"USBConnectionEvent", USBConnectionEventExposedConstructCallback}, 
{"USBDevice", USBDeviceExposedConstructCallback}, 
{"USBEndpoint", USBEndpointExposedConstructCallback}, 
{"USBInTransferResult", USBInTransferResultExposedConstructCallback}, 
{"USBInterface", USBInterfaceExposedConstructCallback}, 
{"USBIsochronousInTransferPacket", USBIsochronousInTransferPacketExposedConstructCallback}, 
{"USBIsochronousInTransferResult", USBIsochronousInTransferResultExposedConstructCallback}, 
{"USBIsochronousOutTransferPacket", USBIsochronousOutTransferPacketExposedConstructCallback}, 
{"USBIsochronousOutTransferResult", USBIsochronousOutTransferResultExposedConstructCallback}, 
{"USBOutTransferResult", USBOutTransferResultExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebCodecsVideoEncoderBuffersEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"VideoEncoderBuffer", VideoEncoderBufferExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::SystemWakeLockEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WakeLock", WakeLockExposedConstructCallback}, 
{"WakeLockSentinel", WakeLockSentinelExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_isolated_context && is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebPrintingEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WebPrintingManager", WebPrintingManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIWriterAPIForWorkersEnabled() && RuntimeEnabledFeatures::AIWriterAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIWriterAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Writer", WriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}



}


}  // namespace blink
