// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_decrypt_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_encryption_pattern.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_subsample_entry.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"encryptionPattern",
"encryptionScheme",
"initializationVector",
"keyId",
"subsampleLayout",
};


}  // namespace 

DecryptConfig* DecryptConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  DecryptConfig* dictionary = MakeGarbageCollected<DecryptConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "DecryptConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 DecryptConfig::DecryptConfig() {
  
}

 DecryptConfig::DecryptConfig(v8::Isolate* isolate) {
  
}










void DecryptConfig::setEncryptionScheme(const String& value) {
  member_encryption_scheme_ = value;
}

void DecryptConfig::setEncryptionScheme(String&& value) {
  member_encryption_scheme_ = std::move(value);
}














void DecryptConfig::setSubsampleLayout(const HeapVector<Member<SubsampleEntry>>& value) {
  member_subsample_layout_ = value;
}

void DecryptConfig::setSubsampleLayout(HeapVector<Member<SubsampleEntry>>&& value) {
  member_subsample_layout_ = std::move(value);
}



void DecryptConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_encryption_pattern_);
visitor->Trace(member_initialization_vector_);
visitor->Trace(member_key_id_);
visitor->Trace(member_subsample_layout_);
bindings::InputDictionaryBase::Trace(visitor);
}

void DecryptConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "DecryptConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("encryptionPattern");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<EncryptionPattern, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_encryption_pattern_, member_encryption_pattern_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("encryptionScheme");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_encryption_scheme_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("initializationVector");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_initialization_vector_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keyId");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_key_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("subsampleLayout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<SubsampleEntry>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_subsample_layout_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> DecryptConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
