// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CREDENTIAL_REQUEST_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CREDENTIAL_REQUEST_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_credential_mediation_requirement.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_credential_ui_mode_requirement.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AbortSignal;
class DigitalCredentialRequestOptions;
class ExceptionState;
class FederatedCredentialRequestOptions;
class IdentityCredentialRequestOptions;
class OTPCredentialRequestOptions;
class PublicKeyCredentialRequestOptions;

class MODULES_EXPORT CredentialRequestOptions : public bindings::InputDictionaryBase {
  
  public:
static CredentialRequestOptions* Create() {
  return MakeGarbageCollected<CredentialRequestOptions>();
}
static CredentialRequestOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CredentialRequestOptions>(isolate);
}
static CredentialRequestOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CredentialRequestOptions();
explicit  CredentialRequestOptions(v8::Isolate* isolate);

bool hasDigital() const {
  return has_digital_;
}
DigitalCredentialRequestOptions* digital() const {
  DCHECK(hasDigital());
return member_digital_.Get();
}
DigitalCredentialRequestOptions* getDigitalOr(DigitalCredentialRequestOptions* fallback_value) const {
  if (!hasDigital()) {
  return fallback_value;
}
return member_digital_.Get();
}
void setDigital(DigitalCredentialRequestOptions* value) {
  member_digital_ = value;
has_digital_ = true;
DCHECK(member_digital_);
}

bool hasFederated() const {
  return has_federated_;
}
FederatedCredentialRequestOptions* federated() const {
  DCHECK(hasFederated());
return member_federated_.Get();
}
FederatedCredentialRequestOptions* getFederatedOr(FederatedCredentialRequestOptions* fallback_value) const {
  if (!hasFederated()) {
  return fallback_value;
}
return member_federated_.Get();
}
void setFederated(FederatedCredentialRequestOptions* value) {
  member_federated_ = value;
has_federated_ = true;
DCHECK(member_federated_);
}

bool hasIdentity() const {
  return has_identity_;
}
IdentityCredentialRequestOptions* identity() const {
  DCHECK(hasIdentity());
return member_identity_.Get();
}
IdentityCredentialRequestOptions* getIdentityOr(IdentityCredentialRequestOptions* fallback_value) const {
  if (!hasIdentity()) {
  return fallback_value;
}
return member_identity_.Get();
}
void setIdentity(IdentityCredentialRequestOptions* value) {
  member_identity_ = value;
has_identity_ = true;
DCHECK(member_identity_);
}

bool hasMediation() const {
  return true;
}
V8CredentialMediationRequirement mediation() const {
  return member_mediation_;
}
void setMediation(V8CredentialMediationRequirement value) {
  member_mediation_ = value;
}
void setMediation(V8CredentialMediationRequirement::Enum value) {
  member_mediation_ = V8CredentialMediationRequirement(value);
}

bool hasOtp() const {
  return has_otp_;
}
OTPCredentialRequestOptions* otp() const {
  DCHECK(hasOtp());
return member_otp_.Get();
}
OTPCredentialRequestOptions* getOtpOr(OTPCredentialRequestOptions* fallback_value) const {
  if (!hasOtp()) {
  return fallback_value;
}
return member_otp_.Get();
}
void setOtp(OTPCredentialRequestOptions* value) {
  member_otp_ = value;
has_otp_ = true;
DCHECK(member_otp_);
}

bool hasPassword() const {
  return true;
}
bool password() const {
  return member_password_;
}
void setPassword(bool value) {
  member_password_ = value;
}

bool hasPublicKey() const {
  return has_public_key_;
}
PublicKeyCredentialRequestOptions* publicKey() const {
  DCHECK(hasPublicKey());
return member_public_key_.Get();
}
PublicKeyCredentialRequestOptions* getPublicKeyOr(PublicKeyCredentialRequestOptions* fallback_value) const {
  if (!hasPublicKey()) {
  return fallback_value;
}
return member_public_key_.Get();
}
void setPublicKey(PublicKeyCredentialRequestOptions* value) {
  member_public_key_ = value;
has_public_key_ = true;
DCHECK(member_public_key_);
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}

bool hasUiMode() const {
  return true;
}
V8CredentialUiModeRequirement uiMode() const {
  return member_ui_mode_;
}
void setUiMode(V8CredentialUiModeRequirement value) {
  member_ui_mode_ = value;
}
void setUiMode(V8CredentialUiModeRequirement::Enum value) {
  member_ui_mode_ = V8CredentialUiModeRequirement(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_digital_ = false;
bool has_federated_ = false;
bool has_identity_ = false;
bool has_otp_ = false;
bool has_public_key_ = false;
bool has_signal_ = false;

Member<DigitalCredentialRequestOptions> member_digital_;
Member<FederatedCredentialRequestOptions> member_federated_;
Member<IdentityCredentialRequestOptions> member_identity_;
V8CredentialMediationRequirement member_mediation_{V8CredentialMediationRequirement::Enum::kOptional};
Member<OTPCredentialRequestOptions> member_otp_;
bool member_password_{false};
Member<PublicKeyCredentialRequestOptions> member_public_key_;
Member<AbortSignal> member_signal_;
V8CredentialUiModeRequirement member_ui_mode_{V8CredentialUiModeRequirement::Enum::kActive};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CREDENTIAL_REQUEST_OPTIONS_H_
