// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_READ_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_READ_OPTIONS_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ClipboardReadOptions : public bindings::InputDictionaryBase {
  
  public:
static ClipboardReadOptions* Create() {
  return MakeGarbageCollected<ClipboardReadOptions>();
}
static ClipboardReadOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ClipboardReadOptions>(isolate);
}
static ClipboardReadOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ClipboardReadOptions();
explicit  ClipboardReadOptions(v8::Isolate* isolate);

bool hasTypes() const {
  return has_types_;
}
const std::optional<Vector<String>>& types() const {
  DCHECK(hasTypes());
return member_types_;
}
std::optional<Vector<String>> getTypesOr(const std::optional<Vector<String>>& fallback_value) const;
std::optional<Vector<String>> getTypesOr(std::optional<Vector<String>>&& fallback_value) const;
void setTypes(const std::optional<Vector<String>>& value);
void setTypes(std::optional<Vector<String>>&& value);
void setTypes(const Vector<String>& value);
void setTypes(Vector<String>&& value);

bool hasUnsanitized() const {
  return has_unsanitized_;
}
const Vector<String>& unsanitized() const {
  DCHECK(hasUnsanitized());
return member_unsanitized_;
}
Vector<String> getUnsanitizedOr(const Vector<String>& fallback_value) const;
Vector<String> getUnsanitizedOr(Vector<String>&& fallback_value) const;
void setUnsanitized(const Vector<String>& value);
void setUnsanitized(Vector<String>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_types_ = false;
bool has_unsanitized_ = false;

std::optional<Vector<String>> member_types_;
Vector<String> member_unsanitized_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_READ_OPTIONS_H_
