// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ClipboardChangeEventInit : public EventInit {
  
  public:
static ClipboardChangeEventInit* Create() {
  return MakeGarbageCollected<ClipboardChangeEventInit>();
}
static ClipboardChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ClipboardChangeEventInit>(isolate);
}
static ClipboardChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ClipboardChangeEventInit();
explicit  ClipboardChangeEventInit(v8::Isolate* isolate);

bool hasChangeId() const {
  return has_change_id_;
}
const BigInt& changeId() const {
  DCHECK(hasChangeId());
return member_change_id_;
}
BigInt getChangeIdOr(const BigInt& fallback_value) const {
  if (!hasChangeId()) {
  return fallback_value;
}
return member_change_id_;
}
void setChangeId(const BigInt& value) {
  member_change_id_ = value;
has_change_id_ = true;
}

bool hasTypes() const {
  return has_types_;
}
const Vector<String>& types() const {
  DCHECK(hasTypes());
return member_types_;
}
Vector<String> getTypesOr(const Vector<String>& fallback_value) const;
Vector<String> getTypesOr(Vector<String>&& fallback_value) const;
void setTypes(const Vector<String>& value);
void setTypes(Vector<String>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_change_id_ = false;
bool has_types_ = false;

BigInt member_change_id_;
Vector<String> member_types_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_CHANGE_EVENT_INIT_H_
